/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.particles.ParticleInit;
import com.ma.blocks.tileentities.TileEntityInit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class TileEntitySlipstreamGenerator
extends TileEntity
implements ITickableTileEntity {
    private ArrayList<PlayerEntity> levitatingEntities = new ArrayList();
    private int updateTicks = 1;
    private static final int EFFECT_HEIGHT = 50;

    public TileEntitySlipstreamGenerator() {
        super((TileEntityType)TileEntityInit.SLIPSTREAM_GENERATOR.get());
    }

    public void func_73660_a() {
        if (this.updateTicks++ > 10) {
            this.refreshPlayerList();
            this.updateTicks = 0;
        }
        Iterator<PlayerEntity> it = this.levitatingEntities.iterator();
        while (it.hasNext()) {
            PlayerEntity player = it.next();
            if (!this.playerIsValid(player)) {
                it.remove();
                continue;
            }
            player.func_213317_d(new Vector3d(player.func_213322_ci().func_82615_a(), player.func_213322_ci().func_82617_b() * 0.5999999, player.func_213322_ci().func_82616_c()));
            if (Math.abs(player.func_213322_ci().field_72448_b) < 0.2) {
                player.func_70024_g(0.0, -player.func_213322_ci().field_72448_b, 0.0);
                player.field_70143_R = 0.0f;
            } else {
                player.field_70143_R -= 1.0f;
            }
            if (!player.func_225608_bj_()) {
                float pitch = player.field_70125_A;
                float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
                if (Math.abs(pitch) > 10.0f) {
                    player.func_213315_a(MoverType.PLAYER, new Vector3d(0.0, (double)factor, 0.0));
                }
            }
            if (!this.field_145850_b.field_72995_K) continue;
            this.spawnParticles(player);
        }
    }

    private void spawnParticles(PlayerEntity player) {
        float pitch = player.field_70125_A;
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (player.func_225608_bj_()) {
            factor = 0.01f;
        }
        for (int i = 0; i < 5; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.AIR_ORBIT.get(), player.func_226277_ct_(), player.func_225608_bj_() ? player.func_226278_cu_() : player.func_226278_cu_() + (double)factor + Math.random() * (double)player.func_213302_cg(), player.func_226281_cx_(), (double)0.1f, (double)factor, 1.0);
        }
    }

    private boolean playerIsValid(PlayerEntity player) {
        if (player == null || !player.func_70089_S()) {
            return false;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v().func_177979_c(50), this.func_174877_v().func_177982_a(1, 50, 1));
        return player.func_174813_aQ().func_72326_a(bb);
    }

    private void refreshPlayerList() {
        this.levitatingEntities.clear();
        this.levitatingEntities.addAll(this.field_145850_b.func_217369_A().stream().filter(p -> this.playerIsValid((PlayerEntity)p) && !this.levitatingEntities.contains(p)).collect(Collectors.toList()));
    }
}

