/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.blocks.tileentities.TileEntityArcaneSentry;
import com.ma.entities.models.NonClippingBookModel;
import com.ma.tools.math.MathUtilities;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class ArcaneSentryRenderer
extends TileEntityRenderer<TileEntityArcaneSentry> {
    public static final RenderMaterial TEXTURE_BOOK = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/enchanting_table_book"));
    private final NonClippingBookModel modelBook = new NonClippingBookModel();
    ResourceLocation location = new ResourceLocation("mana-and-artifice", "block/arcane_sentry");
    private final Vector3 TARGET_POSITION = new Vector3(0.5, 1.25, 0.5);
    private final Vector3 NO_TARGET_POSITION = new Vector3(0.5, 0.08, 0.7);

    public ArcaneSentryRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityArcaneSentry tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f1;
        float f = (float)tileEntityIn.ticks + partialTicks;
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        float t = MathUtilities.clamp01(((float)tileEntityIn.ticksSinceTargetChange + partialTicks) / 10.0f);
        matrixStackIn.func_227860_a_();
        Vector3 vOffset = tileEntityIn.hasTarget() ? Vector3.lerp(this.NO_TARGET_POSITION, this.TARGET_POSITION, t) : Vector3.lerp(this.TARGET_POSITION, this.NO_TARGET_POSITION, t);
        matrixStackIn.func_227861_a_((double)vOffset.x, (double)vOffset.y, (double)vOffset.z);
        matrixStackIn.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = tileEntityIn.nextPageAngle - tileEntityIn.pageAngle; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = (float)Math.toDegrees(tileEntityIn.pageAngle + f1 * partialTicks);
        float zpRotation = tileEntityIn.hasTarget() ? MathUtilities.lerpf(90.0f, 0.0f, t) : MathUtilities.lerpf(0.0f, 90.0f, t);
        float ypRotation = tileEntityIn.hasTarget() ? MathUtilities.lerpf(90.0f, -f2, t) : MathUtilities.lerpf(-f2, 90.0f, t);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(zpRotation));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ypRotation));
        float f3 = MathHelper.func_219799_g((float)partialTicks, (float)tileEntityIn.field_195524_g, (float)tileEntityIn.field_195523_f);
        float f4 = MathHelper.func_226164_h_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = MathHelper.func_226164_h_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)tileEntityIn.pageTurningSpeed, (float)tileEntityIn.nextPageTurningSpeed);
        this.modelBook.setBookState(f, MathHelper.func_76131_a((float)f4, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)f5, (float)0.0f, (float)1.0f), f6);
        IVertexBuilder ivertexbuilder = TEXTURE_BOOK.func_229311_a_(bufferIn, RenderType::func_228634_a_);
        this.modelBook.renderAll(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.5f, 1.0f, 0.5f);
        matrixStackIn.func_227861_a_(1.0, (double)0.01f, 1.0);
        if (tileEntityIn.hasTarget()) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
        }
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false));
        Minecraft mc = Minecraft.func_71410_x();
        IBakedModel model = mc.func_209506_al().getModel(this.location);
        IModelData data = model.getModelData((IBlockDisplayReader)world, pos, state, ModelDataManager.getModelData((World)world, (BlockPos)pos));
        Random random = new Random(1234L);
        for (BakedQuad quad : model.getQuads(null, null, random, data)) {
            vertexBuilder.addVertexData(matrixStackIn.func_227866_c_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, true);
        }
        matrixStackIn.func_227865_b_();
    }
}

