/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.ManaAndArtifice;
import com.ma.blocks.artifice.BlockConstructWorkbench;
import com.ma.blocks.tileentities.TileEntityConstructWorkbench;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.models.constructs.AnimatedConstructModel;
import com.ma.items.constructs.parts._base.ConstructMaterial;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.tools.render.MARenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.util.AnimationUtils;

public class ConstructWorkbenchRenderer
extends TileEntityRenderer<TileEntityConstructWorkbench> {
    private static final float triangle_height = (float)(Math.sqrt(3.0) / 2.0);

    public ConstructWorkbenchRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityConstructWorkbench tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.45, 0.7, -0.2);
        matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
        Direction dir = (Direction)tileEntityIn.func_195044_w().func_177229_b((Property)BlockConstructWorkbench.FACING);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(dir.func_185119_l() - 90.0f));
        switch (dir) {
            case EAST: {
                matrixStackIn.func_227861_a_((double)-0.1f, (double)0.325f, 0.0);
                break;
            }
            case NORTH: {
                matrixStackIn.func_227861_a_((double)-0.9f, (double)-0.65f, 0.0);
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227861_a_((double)0.95f, (double)-0.55f, 0.0);
                break;
            }
            case WEST: {
                matrixStackIn.func_227861_a_((double)0.05f, (double)-1.525f, 0.0);
            }
        }
        try {
            EntityAnimatedConstruct dummy = ManaAndArtifice.instance.proxy.getDummyConstructForRender();
            EntityRenderer geoRenderer = AnimationUtils.getRenderer((Entity)dummy);
            AnimatedConstructModel model = (AnimatedConstructModel)AnimationUtils.getGeoModelForEntity((Entity)dummy);
            model.getModel(model.getModelLocation(dummy));
            for (ConstructMaterial matl : tileEntityIn.getConstruct().getComposition()) {
                model.resetMutexVisibility();
                model.setActiveMaterial(matl);
                dummy.getConstructData().resetParts();
                for (ItemConstructPart part : tileEntityIn.getConstruct().getPartsForMaterial(matl)) {
                    dummy.getConstructData().setPart(part);
                    model.setMutexVisibility(part.getSlot(), part.getModelTypeMutex(), null);
                }
                matrixStackIn.func_227860_a_();
                geoRenderer.func_225623_a_((Entity)dummy, 0.0f, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.func_227865_b_();
            }
        }
        catch (Exception dummy) {
            // empty catch block
        }
        matrixStackIn.func_227865_b_();
        if (tileEntityIn.getIsCrafting()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.7, 0.5);
            int craftTicks = (int)ManaAndArtifice.instance.proxy.getGameTicks();
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            ConstructWorkbenchRenderer.renderHorizontalRadiant(craftTicks, matrixStackIn, bufferIn);
            ConstructWorkbenchRenderer.renderVerticalRadiant(craftTicks, matrixStackIn, bufferIn, partialTicks);
            matrixStackIn.func_227865_b_();
        }
    }

    private static void renderVerticalRadiant(int ticks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float partialTicks) {
        Random random = new Random(1234L);
        IVertexBuilder lightingBuilder = bufferIn.getBuffer(MARenderTypes.RADIANT_RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        Random rand = new Random(333L);
        for (int i = 0; i < 40; ++i) {
            matrixStackIn.func_227860_a_();
            int[] colorStart = new int[]{255, 255, 255};
            int[] colorEnd = new int[]{rand.nextBoolean() ? rand.nextInt(255) : 0, rand.nextBoolean() ? rand.nextInt(128) : 0, rand.nextBoolean() ? rand.nextInt(255) : 0};
            rand = new Random(i);
            matrixStackIn.func_227862_a_(3.0f, 3.0f, 3.0f);
            Matrix4f currentMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
            int alpha = 20 - (int)Math.round(Math.sin(((float)ticks + partialTicks + (float)i) / 3.0f) * 20.0);
            float width = 0.02f;
            matrixStackIn.func_227861_a_((double)(-0.15f + random.nextFloat() * 0.3f), 0.0, (double)(-0.15f + random.nextFloat() * 0.3f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f + 90.0f));
            ConstructWorkbenchRenderer.addVertex(lightingBuilder, currentMatrix, -width, 0.0f, -width, alpha, colorStart);
            ConstructWorkbenchRenderer.addVertex(lightingBuilder, currentMatrix, width, 0.0f, width, alpha, colorStart);
            ConstructWorkbenchRenderer.addVertex(lightingBuilder, currentMatrix, width, -0.2f, width, 0, colorEnd);
            ConstructWorkbenchRenderer.addVertex(lightingBuilder, currentMatrix, -width, -0.2f, -width, 0, colorEnd);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    private static void renderHorizontalRadiant(int ticks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        float rotationByAge = (float)ticks / 220.0f;
        Random random = new Random(1234L);
        IVertexBuilder lightingBuilder = bufferIn.getBuffer(MARenderTypes.RADIANT_RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(5.0f, 5.0f, 5.0f);
        Random rand = new Random(333L);
        for (int i = 0; i < 20; ++i) {
            int[] colorStart = new int[]{rand.nextBoolean() ? rand.nextInt(128) : 0, rand.nextBoolean() ? rand.nextInt(255) : 0, rand.nextBoolean() ? rand.nextInt(255) : 0};
            int[] colorEnd = new int[]{rand.nextBoolean() ? rand.nextInt(255) : 0, rand.nextBoolean() ? rand.nextInt(128) : 0, rand.nextBoolean() ? rand.nextInt(255) : 0};
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = 0.0f;
            float vOffset = 0.15f + random.nextFloat() * 0.25f;
            Matrix4f currentMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
            int alpha = 40;
            ConstructWorkbenchRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            ConstructWorkbenchRenderer.addVertexNegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            ConstructWorkbenchRenderer.addVertexPositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            ConstructWorkbenchRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            ConstructWorkbenchRenderer.addVertexPositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            ConstructWorkbenchRenderer.addVertexNoOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            ConstructWorkbenchRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            ConstructWorkbenchRenderer.addVertexNoOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            ConstructWorkbenchRenderer.addVertexNegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addStartVertices(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, int alpha, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_181675_d();
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(colors[0], colors[1], colors[2], alpha).func_181675_d();
    }

    private static void addVertex(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float x, float y, float z, int alpha, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, x, y, z).func_225586_a_(colors[0], colors[1], colors[2], alpha).func_181675_d();
    }

    private static void addVertexNegativeOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, -triangle_height * hOffset, vOffset, -0.5f * hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }

    private static void addVertexPositiveOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, triangle_height * hOffset, vOffset, -0.5f * hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }

    private static void addVertexNoOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, vOffset, hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }
}

