/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.blocks.tileentities.TileEntityLodestar;
import com.ma.tools.math.MathUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class LodestarRenderer
extends TileEntityRenderer<TileEntityLodestar> {
    private Minecraft mc;
    private final ResourceLocation location = new ResourceLocation("mana-and-artifice", "block/lodestar_blocking_cube");

    public LodestarRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.mc = Minecraft.func_71410_x();
    }

    public void render(TileEntityLodestar tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        Random random = new Random(1234L);
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false));
        IBakedModel model = this.mc.func_209506_al().getModel(this.location);
        IModelData data = model.getModelData((IBlockDisplayReader)world, pos, state, ModelDataManager.getModelData((World)world, (BlockPos)pos));
        float distance = MathUtilities.clamp01((float)tileEntityIn.expandCount() / 20.0f);
        float angle = (float)(tileEntityIn.expandCount() % 40) / 40.0f * 360.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.0f, 1.01f, 1.0f);
        matrixStackIn.func_227861_a_(0.5, -0.01, 0.5);
        for (int i = 0; i < 4; ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(90 * i)));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            matrixStackIn.func_227862_a_(1.0f - 0.5f * distance, 1.0f - 0.5f * distance, 1.0f - 0.5f * distance);
            matrixStackIn.func_227861_a_((double)distance, (double)distance, (double)distance);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            for (BakedQuad quad : model.getQuads(null, null, random, data)) {
                vertexBuilder.addVertexData(matrixStackIn.func_227866_c_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, true);
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }
}

