/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.TileEntityMagelight;
import com.ma.config.GeneralClientConfig;
import com.ma.tools.render.MARenderTypes;
import com.ma.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class MageLightRenderer
extends TileEntityRenderer<TileEntityMagelight> {
    public MageLightRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityMagelight tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int[] inner = new int[]{4, 27, 255};
        int[] outer = new int[]{20, 45, 222};
        int[] ring = new int[]{255, 255, 255};
        Quaternion cameraRotation = Minecraft.func_71410_x().func_175598_ae().func_229098_b_();
        Quaternion portalRotation = new Quaternion(0.0f, cameraRotation.func_195891_b(), 0.0f, cameraRotation.func_195894_d());
        float portalSpinDegrees = ManaAndArtifice.instance.proxy.getGameTicks() * 3L % 360L;
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(MARenderTypes.MAGELIGHT);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227860_a_();
        float ringScale = 0.2f;
        matrixStackIn.func_227862_a_(ringScale, ringScale, ringScale);
        matrixStackIn.func_227863_a_(portalRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-portalSpinDegrees));
        matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        float nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
        float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
        MageLightRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, combinedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, ring);
        MageLightRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, combinedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, ring);
        MageLightRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, combinedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, ring);
        MageLightRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, combinedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, ring);
        matrixStackIn.func_227865_b_();
        if (((Boolean)GeneralClientConfig.FANCY_MAGELIGHTS.get()).booleanValue()) {
            WorldRenderUtils.renderRadiant((float)((int)tileEntityIn.func_145831_w().func_82737_E()) / 5.0f + partialTicks, matrixStackIn, bufferIn, inner, outer, 255, 0.75f, false);
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] rgb) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(rgb[0], rgb[1], rgb[2], 64).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normalMatrix, nrmH, nrmV, nrmH).func_181675_d();
    }
}

