/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.blocks.tileentities.TileEntityManaweaveProjector;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class ManaweaveProjectorRenderer
extends TileEntityRenderer<TileEntityManaweaveProjector> {
    private static final ResourceLocation SPARKLE_TEXTURE = new ResourceLocation("mana-and-artifice", "textures/particle/sparkle.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228642_d_((ResourceLocation)SPARKLE_TEXTURE);

    public ManaweaveProjectorRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityManaweaveProjector tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ManaweavingPattern pattern = tileEntityIn.getPattern();
        if (pattern != null) {
            this.renderPattern(pattern, matrixStackIn, bufferIn);
        }
    }

    private void renderPattern(ManaweavingPattern pattern, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        byte[][] points = pattern.get();
        float pointSize = 0.5f;
        float baseScale = 0.03f;
        float offsetX = (float)points.length / 2.0f * pointSize;
        float offsetY = (float)points[0].length / 2.0f * pointSize;
        Quaternion cameraRotation = Minecraft.func_71410_x().func_175598_ae().func_229098_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.8, 0.5);
        matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
        matrixStackIn.func_227863_a_(cameraRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * pointSize;
                float originY = offsetY - (float)i * pointSize;
                ManaweaveProjectorRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f);
                ManaweaveProjectorRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f);
                ManaweaveProjectorRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f);
                ManaweaveProjectorRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(109, 227, 220, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF00000).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

