/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.ManaAndArtifice;
import com.ma.blocks.manaweaving.BlockManaweavingAltar;
import com.ma.blocks.tileentities.TileEntityManaweavingAltar;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.math.MathUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class ManaweavingAltarRenderer
extends TileEntityRenderer<TileEntityManaweavingAltar> {
    private static final ResourceLocation SPARKLE_TEXTURE = new ResourceLocation("mana-and-artifice", "textures/particle/sparkle.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228642_d_((ResourceLocation)SPARKLE_TEXTURE);
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();

    public ManaweavingAltarRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityManaweavingAltar tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack[] itemstacks = tileEntityIn.getDisplayedItems();
        for (int i = 0; i < itemstacks.length; ++i) {
            Random r = new Random((long)i * 1234L);
            if (itemstacks[i].func_190926_b()) continue;
            matrixStackIn.func_227860_a_();
            switch ((Direction)tileEntityIn.func_195044_w().func_177229_b((Property)BlockManaweavingAltar.FACING)) {
                case SOUTH: {
                    matrixStackIn.func_227861_a_(0.5, 1.35, 0.32);
                    break;
                }
                case EAST: {
                    matrixStackIn.func_227861_a_(0.3, 1.35, 0.5);
                    break;
                }
                case WEST: {
                    matrixStackIn.func_227861_a_(0.7, 1.35, 0.5);
                    break;
                }
                default: {
                    matrixStackIn.func_227861_a_(0.5, 1.35, 0.68);
                }
            }
            Vector3d randomPos = new Vector3d(r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f)).func_72432_b();
            randomPos = randomPos.func_186678_a((double)0.3f);
            if (!tileEntityIn.isCrafting()) {
                matrixStackIn.func_227861_a_(randomPos.func_82615_a(), randomPos.func_82617_b(), randomPos.func_82616_c());
            } else {
                float ringAngle = (float)i * (360.0f / (float)itemstacks.length);
                float craftPct = (float)tileEntityIn.getCraftTicks() / (float)tileEntityIn.getMaxCraftTicks();
                Vector3d ringPos = new Vector3d(Math.cos(ringAngle), 0.0, Math.sin(ringAngle)).func_186678_a((double)(1.0f - craftPct));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
                if (tileEntityIn.getCraftTicks() < tileEntityIn.getMaxCraftTicks() / 5) {
                    float pct = (float)tileEntityIn.getCraftTicks() / ((float)tileEntityIn.getMaxCraftTicks() / 5.0f);
                    Vector3d lerpPos = MathUtilities.lerpVector3d(randomPos, ringPos, pct);
                    matrixStackIn.func_227861_a_(lerpPos.func_82615_a(), lerpPos.func_82617_b(), lerpPos.func_82616_c());
                } else {
                    matrixStackIn.func_227861_a_(ringPos.func_82615_a(), ringPos.func_82617_b(), ringPos.func_82616_c());
                }
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227862_a_(0.25f, 0.25f, 0.25f);
            this.itemRenderer.func_229110_a_(itemstacks[i], ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
        int count = 0;
        for (ManaweavingPattern pattern : tileEntityIn.getAddedPatterns()) {
            float xOffset = 0.15f;
            float zOffset = 0.7f;
            float rotation = 0.0f;
            switch ((Direction)tileEntityIn.func_195044_w().func_177229_b((Property)BlockManaweavingAltar.FACING)) {
                case SOUTH: {
                    rotation = 180.0f;
                    break;
                }
                case EAST: {
                    rotation = 90.0f;
                    zOffset = 0.9f;
                    break;
                }
                case WEST: {
                    rotation = -90.0f;
                    zOffset = 0.9f;
                    break;
                }
            }
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
            matrixStackIn.func_227861_a_(0.0, Math.sin(((float)(tileEntityIn.func_145831_w().func_82737_E() + (long)(count * 5)) + partialTicks) / 20.0f) * (double)0.01f, 0.0);
            matrixStackIn.func_227861_a_((double)xOffset + Math.floor((float)count / 3.0f) * 0.75, 0.85, (double)(zOffset - 0.3f * (float)(count % 3)));
            this.renderPattern(pattern, matrixStackIn, bufferIn, rotation);
            matrixStackIn.func_227865_b_();
            ++count;
        }
    }

    private void renderPattern(ManaweavingPattern pattern, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float rotation) {
        byte[][] points = pattern.get();
        float pointSize = 0.5f;
        float baseScale = 0.03f;
        float offsetX = (float)points.length / 2.0f * pointSize;
        float offsetY = (float)points[0].length / 2.0f * pointSize;
        Quaternion cameraRotation = Minecraft.func_71410_x().func_175598_ae().func_229098_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.2, 0.0);
        matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation));
        matrixStackIn.func_227863_a_(cameraRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * pointSize;
                float originY = offsetY - (float)i * pointSize;
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(109, 227, 220, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF00000).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

