/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.capabilities.chunkdata.ChunkMagicProvider;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.entities.EntityInit;
import com.ma.entities.faction.FactionRaidEntity;
import com.ma.network.ServerMessageDispatcher;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MACapabilityForgeEventHandlers {
    public static final ResourceLocation PLAYERMAGIC_CAP = new ResourceLocation("mana-and-artifice", "magic");
    public static final ResourceLocation WORLDMAGIC_CAP = new ResourceLocation("mana-and-artifice", "worldmagic");
    public static final ResourceLocation CHUNKMAGIC_CAP = new ResourceLocation("mana-and-artifice", "chunkmagic");
    public static final ResourceLocation PROGRESSION_CAP = new ResourceLocation("mana-and-artifice", "progression");
    public static final ResourceLocation ROTE_SPELLS_CAP = new ResourceLocation("mana-and-artifice", "rote_spells");

    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(PLAYERMAGIC_CAP, (ICapabilityProvider)new PlayerMagicProvider());
        event.addCapability(PROGRESSION_CAP, (ICapabilityProvider)new PlayerProgressionProvider());
        event.addCapability(ROTE_SPELLS_CAP, (ICapabilityProvider)new PlayerRoteSpellsProvider());
    }

    @SubscribeEvent
    public static void attachWorldCapability(AttachCapabilitiesEvent<World> event) {
        if (!(event.getObject() instanceof ServerWorld)) {
            return;
        }
        event.addCapability(WORLDMAGIC_CAP, (ICapabilityProvider)new WorldMagicProvider());
    }

    @SubscribeEvent
    public static void attachChunkCapability(AttachCapabilitiesEvent<Chunk> event) {
        if (!(event.getObject() instanceof Chunk)) {
            return;
        }
        event.addCapability(CHUNKMAGIC_CAP, (ICapabilityProvider)new ChunkMagicProvider());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        IPlayerMagic mana = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC, null).orElse(null);
        IPlayerMagic oldMana = (IPlayerMagic)event.getOriginal().getCapability(PlayerMagicProvider.MAGIC, null).orElse(null);
        if (mana != null && oldMana != null) {
            mana.copyFrom(oldMana);
        } else {
            ManaAndArtifice.LOGGER.error("M&A -> Failed to copy magic data over when player was cloned (one of them was NULL!)");
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION, null).orElse(null);
        IPlayerProgression oldProgression = (IPlayerProgression)event.getOriginal().getCapability(PlayerProgressionProvider.PROGRESSION, null).orElse(null);
        if (progression != null && oldProgression != null) {
            progression.setAlliedFaction(oldProgression.getAlliedFaction());
            progression.setFactionStanding(oldProgression.getFactionStanding());
            progression.setTier(oldProgression.getTier(), player);
            progression.setTierProgression(oldProgression.getCompletedProgressionSteps());
        } else {
            ManaAndArtifice.LOGGER.error("M&A -> Failed to copy progression data over when player was cloned (one of them was NULL!)");
        }
        IPlayerRoteSpells rote = (IPlayerRoteSpells)player.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        IPlayerRoteSpells oldRote = (IPlayerRoteSpells)event.getOriginal().getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        if (rote != null && oldRote != null) {
            rote.copyFrom(oldRote);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getPlayer().getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> magic.forceSync());
        event.getPlayer().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> progression.setDirty());
        event.getPlayer().getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(rote -> rote.setDirty());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MACapabilityForgeEventHandlers.tickMagic(event);
        MACapabilityForgeEventHandlers.tickRaids(event);
    }

    private static void tickMagic(TickEvent.PlayerTickEvent event) {
        IPlayerMagic magic = (IPlayerMagic)event.player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            magic.tick(event.player);
        }
        if (event.side == LogicalSide.SERVER) {
            if (magic != null && magic.needsSync()) {
                ServerMessageDispatcher.sendMagicSyncMessage((ServerPlayerEntity)event.player);
                magic.clearSyncFlag();
            }
            event.player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                if (p.needsSync()) {
                    ServerMessageDispatcher.sendProgressionSyncMessage((ServerPlayerEntity)event.player);
                    p.clearSyncFlag();
                }
            });
            event.player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
                if (r.isDirty()) {
                    ServerMessageDispatcher.sendRoteSyncMessage((ServerPlayerEntity)event.player);
                    r.clearDirty();
                }
            });
        }
    }

    private static void tickRaids(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.player.field_70170_p.func_73046_m().func_240793_aU_().func_176130_y() == Difficulty.PEACEFUL) {
                return;
            }
            if (event.player.field_70170_p.func_82737_E() % 100L != 0L) {
                return;
            }
            event.player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                p.incrementRaidChance(event.player);
                if (p.canBeRaided(event.player)) {
                    int hRadius = 20;
                    int vRadius = 3;
                    BlockPos baseline = event.player.func_233580_cy_();
                    for (int i = 0; i < (Integer)GeneralModConfig.RAID_SPAWN_ATTEMPTS.get(); ++i) {
                        RayTraceContext context;
                        BlockRayTraceResult result;
                        BlockPos attemptedLocation = baseline.func_177963_a((double)(-hRadius) + Math.random() * (double)hRadius * 2.0, (double)(-vRadius) + Math.random() * (double)vRadius * 2.0, (double)(-hRadius) + Math.random() * (double)hRadius * 2.0);
                        while (attemptedLocation.func_177956_o() > 5 && !event.player.field_70170_p.func_180495_p(attemptedLocation).func_200132_m()) {
                            attemptedLocation = attemptedLocation.func_177977_b();
                        }
                        while (attemptedLocation.func_177956_o() < event.player.field_70170_p.func_217301_I() && !event.player.field_70170_p.func_175623_d(attemptedLocation)) {
                            attemptedLocation = attemptedLocation.func_177984_a();
                        }
                        BlockPos attemptedLocUp = attemptedLocation.func_177984_a();
                        if (event.player.func_195048_a(new Vector3d((double)attemptedLocation.func_177958_n(), (double)attemptedLocation.func_177956_o(), (double)attemptedLocation.func_177952_p())) < 25.0 || !event.player.field_70170_p.func_175623_d(attemptedLocation) || !event.player.field_70170_p.func_175623_d(attemptedLocUp) || event.player.field_70170_p.func_175623_d(attemptedLocation.func_177977_b()) || (result = event.player.field_70170_p.func_217299_a(context = new RayTraceContext(event.player.func_174824_e(0.0f), new Vector3d((double)attemptedLocUp.func_177958_n() + 0.5, (double)attemptedLocUp.func_177956_o(), (double)attemptedLocUp.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, null))).func_216346_c() != RayTraceResult.Type.MISS) continue;
                        BlockState spawnBlock = event.player.field_70170_p.func_180495_p(attemptedLocation.func_177977_b());
                        if (!spawnBlock.func_215688_a((IBlockReader)event.player.field_70170_p, attemptedLocation.func_177977_b(), (EntityType)EntityInit.FACTION_RAID_ENTITY.get())) {
                            return;
                        }
                        if (event.player.field_70170_p.func_201696_r(attemptedLocUp) > 7) {
                            return;
                        }
                        FactionRaidEntity fre = new FactionRaidEntity(event.player.field_70170_p, event.player, p.getRelativeRaidStrength(event.player));
                        fre.setFaction(p.getAlliedFaction().getRandomEnemyFaction());
                        fre.func_70107_b((double)attemptedLocUp.func_177958_n() + 0.5, attemptedLocUp.func_177956_o(), (double)attemptedLocUp.func_177952_p() + 0.5);
                        event.player.field_70170_p.func_217376_c((Entity)fre);
                        p.setRaidChance(0.0);
                        return;
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        event.getWorld().getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> {
            if (event.getEntity().func_184222_aU() && (event.getEntity() instanceof IMob || event.getEntity() instanceof ChickenEntity && ((ChickenEntity)event.getEntity()).func_152116_bZ()) && w.isWithinWardingCandle(event.getEntity().func_233580_cy_()) && !((String)GeneralModConfig.MA_WARD_BLACKLIST.get()).contains(event.getEntity().func_200600_R().getRegistryName().toString())) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onCheckSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (event.getWorld() instanceof World) {
            ((World)event.getWorld()).getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> {
                if (event.getEntity().func_184222_aU() && (event.getEntity() instanceof IMob || event.getEntity() instanceof ChickenEntity && ((ChickenEntity)event.getEntity()).func_152116_bZ()) && w.isWithinWardingCandle(event.getEntity().func_233580_cy_()) && !((String)GeneralModConfig.MA_WARD_BLACKLIST.get()).contains(event.getEntity().func_200600_R().getRegistryName().toString())) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMobGriefing(EntityMobGriefingEvent event) {
        if (event == null || event.getEntity() == null || event.getEntity().field_70170_p == null) {
            ManaAndArtifice.LOGGER.error("M&A Warding Candle:  Caught EntityMobGriefingEvent event but the entity parameter is null even though the getEntity() method is not flagged as @Nullable.  Allowing the event through because without this parameter there is no way to check a warding candle radius without this parameter.  To be clear:  THIS IS NOT AN M&A BUG.  THIS IS A FORGE ISSUE.");
            return;
        }
        if (event.getEntity().func_184222_aU()) {
            event.getEntity().field_70170_p.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> {
                if (w.isWithinWardingCandle(event.getEntity().func_233580_cy_()) && !((String)GeneralModConfig.MA_WARD_BLACKLIST.get()).contains(event.getEntity().func_200600_R().getRegistryName().toString())) {
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }
}

