/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.api.capabilities.ICantrip;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class Cantrip
implements ICantrip {
    public static final int NUM_PATTERNS = 3;
    private ArrayList<ResourceLocation> combination;
    private ItemStack spell;
    private BiConsumer<PlayerEntity, Cantrip> effector;
    private String id;
    private boolean stackLocked = false;
    private int delay = 0;
    private int chevrons = 0;
    private SoundEvent matchSound;
    private int tier = 1;

    public Cantrip(String id, BiConsumer<PlayerEntity, Cantrip> effector, ItemStack spell, ResourceLocation ... defaultCombination) {
        this(id, effector, spell, Arrays.asList(defaultCombination));
    }

    public Cantrip(String id, BiConsumer<PlayerEntity, Cantrip> effector, ItemStack spell, List<ResourceLocation> defaultCombination) {
        this.spell = spell;
        this.combination = new ArrayList();
        this.combination.addAll(defaultCombination);
        this.effector = effector;
        this.id = id;
    }

    public boolean matches(List<ManaweavingPattern> patterns) {
        if (patterns.size() != this.combination.size()) {
            return false;
        }
        for (int i = 0; i < this.combination.size(); ++i) {
            if (patterns.get(i).func_199560_c().equals((Object)this.combination.get(i))) continue;
            return false;
        }
        return true;
    }

    public void callEffector(PlayerEntity player) {
        if (this.effector != null) {
            this.effector.accept(player, this);
        }
    }

    @Override
    public ItemStack getSpell() {
        return this.spell;
    }

    @Override
    public void setSpell(ItemStack stack) {
        if (!this.stackLocked) {
            this.spell = stack;
        }
    }

    public Cantrip lockSpell() {
        this.stackLocked = true;
        return this;
    }

    public Cantrip setDelay(int ticks) {
        this.delay = ticks;
        return this;
    }

    public Cantrip setChevrons(int chevrons) {
        this.chevrons = chevrons;
        return this;
    }

    public Cantrip setSound(SoundEvent sound) {
        this.matchSound = sound;
        return this;
    }

    public Cantrip setTier(int tier) {
        this.tier = tier;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public CompoundNBT writeToNBT(boolean patternsOnly) {
        CompoundNBT nbt = new CompoundNBT();
        if (!patternsOnly && !this.spell.func_190926_b()) {
            CompoundNBT spell = new CompoundNBT();
            this.spell.func_77955_b(spell);
            nbt.func_218657_a("spell", (INBT)spell);
        }
        nbt.func_74768_a("count", this.combination.size());
        for (int i = 0; i < this.combination.size(); ++i) {
            nbt.func_74778_a("" + i, this.combination.get(i).toString());
        }
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("spell")) {
            this.spell = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("spell"));
        }
        this.combination.clear();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = new ResourceLocation(nbt.func_74779_i("" + i));
                this.combination.add(rLoc);
            }
        }
    }

    @Override
    public ResourceLocation getPattern(int index) {
        if (index < 0 || index >= this.combination.size()) {
            return null;
        }
        return this.combination.get(index);
    }

    public void setPatterns(List<ResourceLocation> manaweavingPatterns) {
        this.combination.clear();
        this.combination.addAll(manaweavingPatterns);
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public int getChevrons() {
        return this.chevrons;
    }

    @Override
    public SoundEvent getSound() {
        return this.matchSound;
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

