/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.api.capabilities.ICantripData;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.collections.Components;
import com.ma.api.spells.collections.Shapes;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.capabilities.playerdata.magic.Cantrip;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.entities.utility.EntitySpellFX;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.inventory.InventoryCantrips;
import com.ma.items.ItemInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.spells.SpellCaster;
import com.ma.spells.SpellsInit;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.RLoc;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.mutable.MutableInt;

public class CantripData
implements ICantripData {
    private static ItemStack IGNITE_CANTRIP_SPELL = new ItemStack((IItemProvider)ItemInit.SPELL.get());
    private List<Cantrip> cantrips = new ArrayList<Cantrip>();

    public CantripData() {
        this.cantrips.add(new Cantrip("ignite", CantripData::applySpellAtTargetOnDelay, IGNITE_CANTRIP_SPELL, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/triangle")).lockSpell().setDelay(60).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
        this.cantrips.add(new Cantrip("dispel", CantripData::dispel, ItemStack.field_190927_a, RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/inverted_triangle"), RLoc.create("manaweave_patterns/triangle")).lockSpell().setTier(2).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
        this.cantrips.add(new Cantrip("grimoire", CantripData::summonGrimoire, ItemStack.field_190927_a, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/hourglass"), RLoc.create("manaweave_patterns/infinity")).lockSpell().setTier(3).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
        this.cantrips.add(new Cantrip("freeform_spell_a", CantripData::applySpellAtTargetOnDelay, ItemStack.field_190927_a, RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/circle")).setDelay(60).setChevrons(1).setTier(3).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
        this.cantrips.add(new Cantrip("freeform_spell_b", CantripData::applySpellAtTargetOnDelay, ItemStack.field_190927_a, RLoc.create("manaweave_patterns/diamond"), RLoc.create("manaweave_patterns/square")).setDelay(60).setChevrons(2).setTier(4).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
        this.cantrips.add(new Cantrip("freeform_spell_c", CantripData::applySpellAtTargetOnDelay, ItemStack.field_190927_a, RLoc.create("manaweave_patterns/knot2"), RLoc.create("manaweave_patterns/split_triangle")).setDelay(60).setChevrons(3).setTier(5).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH));
    }

    @Override
    @Nullable
    public Cantrip matchAndCastCantrip(PlayerEntity player, List<IRecipe<?>> recipes) {
        MutableInt playerTier = new MutableInt(1);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        ArrayList<ManaweavingPattern> patterns = new ArrayList<ManaweavingPattern>();
        for (IRecipe<?> recipe : recipes) {
            if (!(recipe instanceof ManaweavingPattern)) continue;
            patterns.add(0, (ManaweavingPattern)recipe);
        }
        for (Cantrip cantrip : this.cantrips) {
            if (cantrip.getTier() > playerTier.getValue() || !cantrip.matches(patterns)) continue;
            cantrip.callEffector(player);
            return cantrip;
        }
        return null;
    }

    @Override
    public CompoundNBT writeToNBT(boolean patternsOnly) {
        CompoundNBT nbt = new CompoundNBT();
        this.cantrips.forEach(c -> nbt.func_218657_a(c.getId(), (INBT)c.writeToNBT(patternsOnly)));
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.cantrips.forEach(c -> {
            if (nbt.func_74764_b(c.getId())) {
                c.readFromNBT((CompoundNBT)nbt.func_74781_a(c.getId()));
            }
        });
    }

    public static void applySpellAtTargetOnDelay(PlayerEntity player, Cantrip cantrip) {
        SpellRecipe spell = SpellRecipe.fromNBT(cantrip.getSpell().func_77978_p());
        if (spell.isValid()) {
            DelayedEventQueue.pushEvent(player.field_70170_p, new TimedDelayedEvent<Pair>(player.func_110124_au().toString() + "cantrip", 60, new Pair((Object)player, (Object)cantrip), CantripData::applySpellAtTarget));
        }
    }

    public static void applySpellAtTarget(String id, Pair<PlayerEntity, Cantrip> data) {
        if (data.getFirst() == null || data.getSecond() == null) {
            return;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(((Cantrip)data.getSecond()).getSpell().func_77978_p());
        for (int i = 0; i < 3; ++i) {
            recipe.setModifier(null, i);
        }
        if (recipe.isValid() && !((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isChanneled() && recipe.getReagents((PlayerEntity)data.getFirst(), null).size() == 0) {
            SpellCaster.Affect(((Cantrip)data.getSecond()).getSpell(), recipe, ((PlayerEntity)data.getFirst()).field_70170_p, new SpellSource((LivingEntity)data.getFirst()));
        }
    }

    public static void summonGrimoire(PlayerEntity player, Cantrip cantrip) {
        Vector3d vec = player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z());
        EntityPresentItem entity = new EntityPresentItem(player.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, new ItemStack((IItemProvider)ItemInit.GRIMOIRE.get()));
        entity.func_174869_p();
        player.field_70170_p.func_217376_c((Entity)entity);
    }

    public static void dispel(PlayerEntity player, Cantrip cantrip) {
        player.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB));
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(Shapes.SELF);
        recipe.addComponent(Components.TRUE_INVISIBILITY);
        EntitySpellFX fx = new EntitySpellFX((EntityType)EntityInit.SPELL_FX.get(), player.field_70170_p);
        fx.setCasterUUID(player);
        fx.setRecipe(recipe);
        fx.func_226286_f_(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        player.field_70170_p.func_217376_c((Entity)fx);
    }

    @Override
    public int countRegisteredCantrips() {
        return this.cantrips.size();
    }

    @Override
    @Nullable
    public Cantrip getCantrip(int index) {
        if (index < 0 || index >= this.cantrips.size()) {
            return null;
        }
        return this.cantrips.get(index);
    }

    @Override
    public void setPattern(int cantripIndex, List<ResourceLocation> manaweavingPatterns) {
        Cantrip cantrip = this.getCantrip(cantripIndex);
        if (cantrip != null) {
            cantrip.setPatterns(manaweavingPatterns);
        }
    }

    @Override
    public IInventory getAsInventory() {
        return new InventoryCantrips(this);
    }

    static {
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(SpellsInit.TOUCH);
        recipe.addComponent(SpellsInit.FIRE_DAMAGE);
        recipe.changeComponentAttributeValue(0, Attribute.DAMAGE, 0.0f);
        recipe.changeShapeAttributeValue(Attribute.RANGE, 8.0f);
        recipe.writeToNBT(IGNITE_CANTRIP_SPELL.func_196082_o());
    }
}

