/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChronoAnchorData {
    private float health;
    private float mana;
    private int hunger;
    private BlockPos position;
    private RegistryKey<World> dimension;
    private boolean isValid = false;

    public float getHealth() {
        return this.health;
    }

    public float getMana() {
        return this.mana;
    }

    public int getHunger() {
        return this.hunger;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    protected void setHealth(float health) {
        this.health = health;
    }

    protected void setMana(float mana) {
        this.mana = mana;
    }

    protected void setHunger(int hunger) {
        this.hunger = hunger;
    }

    protected void setPosition(BlockPos position, RegistryKey<World> dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    public boolean canRevert(PlayerEntity player) {
        return this.dimension != null && this.dimension.compareTo(player.field_70170_p.func_234923_W_()) == 0;
    }

    public void fromPlayer(PlayerEntity player) {
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.setHealth(player.func_110143_aJ());
        this.setMana(magic == null ? 0.0f : magic.getMana());
        this.setPosition(player.func_233580_cy_(), (RegistryKey<World>)player.field_70170_p.func_234923_W_());
        this.setHunger(player.func_71024_bL().func_75116_a());
        this.isValid = true;
    }

    public void revert(PlayerEntity player) {
        if (!this.isValid) {
            return;
        }
        if (!this.canRevert(player)) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            magic.setMana(this.getMana());
        }
        player.func_70606_j(this.getHealth());
        player.func_71024_bL().func_75114_a(this.getHunger());
        player.func_70634_a((double)this.getPosition().func_177958_n(), (double)this.getPosition().func_177956_o(), (double)this.getPosition().func_177952_p());
        player.field_70143_R = 0.0f;
        this.isValid = false;
    }

    public void writeToNBT(CompoundNBT compound) {
        if (!this.isValid) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("health", this.getHealth());
        nbt.func_74776_a("mana", this.getMana());
        nbt.func_74768_a("hunger", this.getHunger());
        nbt.func_74768_a("x", this.getPosition().func_177958_n());
        nbt.func_74768_a("y", this.getPosition().func_177956_o());
        nbt.func_74768_a("z", this.getPosition().func_177952_p());
        nbt.func_74778_a("dimension_key_type", this.dimension.getRegistryName().toString());
        nbt.func_74778_a("dimension_key_value", this.dimension.func_240901_a_().toString());
        compound.func_218657_a("chrono_anchor_data", (INBT)nbt);
    }

    public void readFromNBT(CompoundNBT compound) {
        CompoundNBT nbt;
        if (compound.func_74764_b("chrono_anchor_data") && (nbt = compound.func_74775_l("chrono_anchor_data")).func_74764_b("health") && nbt.func_74764_b("mana") && nbt.func_74764_b("hunger") && nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && nbt.func_74764_b("dimension_key_type") && nbt.func_74764_b("dimension_key_value")) {
            this.setHealth(nbt.func_74760_g("health"));
            this.setMana(nbt.func_74760_g("mana"));
            this.setHunger(nbt.func_74762_e("hunger"));
            BlockPos position = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            RegistryKey dimension = new RegistryKey(new ResourceLocation(nbt.func_74779_i("dimension_key_type")), new ResourceLocation(nbt.func_74779_i("dimension_key_value")));
            this.setPosition(position, (RegistryKey<World>)dimension);
            this.isValid = true;
        }
    }
}

