/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.ICantripData;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.CantripData;
import com.ma.capabilities.playerdata.magic.ChronoAnchorData;
import com.ma.effects.EffectInit;
import com.ma.events.EventDispatcher;
import com.ma.inventory.SpellInventory;
import com.ma.items.ItemInit;
import com.ma.items.artifice.SpellModifierRing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerMagic
implements IPlayerMagic {
    private static final float EXHAUSTION_PER_TICK = 3.3333333E-4f;
    private static int MAGIC_LEVELS_PER_MILESTONE = 15;
    private static final int SYNC_INTERVAL = 10;
    private float mana = 100.0f;
    private float max_mana_baseline = 100.0f;
    private int tick_count = 10;
    private int teleport_salt;
    private int portal_cooldown = 0;
    private int magicLevel = 0;
    private int magicXP = 0;
    private int air_casts = 0;
    private int air_jumps = 0;
    private int ticksForRegen = 1200;
    private HashMap<Integer, Float> armor_repair_accumulation;
    private ArrayList<Vector3f> rememberedPoints;
    private ArrayList<Vector3f> rememberedLooks;
    private HashMap<Affinity, Float> affinityDepths;
    private Inventory riftInventory;
    private SpellInventory grimoireInventory;
    private SpellInventory roteInventory;
    private ChronoAnchorData chronoData;
    private CantripData cantripData;
    private Vector3d liftPosition;
    private boolean orbActive = false;
    private float orbMana = 0.0f;
    private HashMap<Enchantment, Integer> orbEnchants = new HashMap();
    private boolean syncGrimoire = true;
    private boolean didAllowFlight = false;
    private boolean needsChronoExhaustion = false;
    private boolean hadWizardSight = false;
    private boolean modifierPressed = false;
    private HashMap<String, Float> maxManaEnhancements;
    private HashMap<String, Float> regenTickEnhancements;

    public PlayerMagic() {
        this.rememberedPoints = new ArrayList();
        this.rememberedLooks = new ArrayList();
        this.chronoData = new ChronoAnchorData();
        this.affinityDepths = new HashMap();
        for (Affinity aff : Affinity.values()) {
            this.affinityDepths.put(aff, Float.valueOf(0.0f));
        }
        this.armor_repair_accumulation = new HashMap();
        this.riftInventory = new Inventory(54);
        this.grimoireInventory = new SpellInventory();
        this.cantripData = new CantripData();
        this.roteInventory = new SpellInventory();
        for (int i = 0; i < this.roteInventory.func_70302_i_(); ++i) {
            this.roteInventory.func_70299_a(i, new ItemStack((IItemProvider)ItemInit.SPELL.get()));
        }
        this.maxManaEnhancements = new HashMap();
        this.regenTickEnhancements = new HashMap();
    }

    public PlayerMagic(float maximum) {
        this();
        this.mana = maximum;
        this.max_mana_baseline = maximum;
    }

    @Override
    public boolean isMagicUnlocked() {
        return this.getMagicLevel() > 0;
    }

    @Override
    public void unlockMagic() {
        if (this.getMagicLevel() == 0) {
            this.setMagicLevel(1);
        }
    }

    @Override
    public void copyFrom(IPlayerMagic other) {
        int i;
        this.maxManaEnhancements.clear();
        other.getMaxManaModifiers().forEach((k, v) -> this.addMaxManaModifier((String)k, v.floatValue()));
        this.regenTickEnhancements.clear();
        other.getRegenTickModifiers().forEach((k, v) -> this.addRegenTickModifier((String)k, v.floatValue()));
        this.setMana(other.getMana());
        this.setTeleportSalt(other.getTeleportSalt());
        this.setMagicXP(other.getMagicXP());
        this.setMagicLevel(other.getMagicLevel());
        this.setPortalCooldown(0);
        this.setAirCasts(0);
        for (i = 0; i < other.getGrimoireInventory().func_70302_i_(); ++i) {
            this.grimoireInventory.func_70299_a(i, other.getGrimoireInventory().func_70301_a(i));
        }
        for (i = 0; i < other.getRiftInventory().func_70302_i_(); ++i) {
            this.riftInventory.func_70299_a(i, other.getRiftInventory().func_70301_a(i));
        }
        for (i = 0; i < other.getRoteInventory().func_70302_i_(); ++i) {
            this.roteInventory.func_70299_a(i, other.getRoteInventory().func_70301_a(i));
        }
        for (Affinity aff : Affinity.values()) {
            this.setAffinityDepth(aff, other.getAffinityDepth(aff));
        }
        this.cantripData = (CantripData)other.getCantripData();
        this.forceSync();
    }

    @Override
    public void consume(float amount) {
        this.mana -= amount;
        if (this.mana < 0.0f) {
            this.mana = 0.0f;
        }
    }

    @Override
    public void restore(float amount) {
        this.mana += amount;
        if (this.mana > this.getMaxMana()) {
            this.mana = this.getMaxMana();
        }
    }

    @Override
    public void setMana(float amount) {
        this.mana = amount;
        if (this.mana < 0.0f) {
            this.mana = 0.0f;
        } else if (this.mana > this.getMaxMana()) {
            this.mana = this.getMaxMana();
        }
    }

    @Override
    public void setMaxMana(float amount) {
        this.max_mana_baseline = amount;
        if (this.max_mana_baseline < 0.0f) {
            this.max_mana_baseline = 0.0f;
        }
    }

    @Override
    public int getRegenTicks() {
        return (int)((float)this.ticksForRegen * this.getRegenModifier());
    }

    @Override
    public void addRegenTickModifier(String id, float pct) {
        if (!this.regenTickEnhancements.containsKey(id) || this.regenTickEnhancements.get(id).floatValue() != pct) {
            this.regenTickEnhancements.put(id, Float.valueOf(pct));
            this.forceSync();
        }
    }

    @Override
    public void clearRegenTickModifiers() {
        this.regenTickEnhancements.clear();
    }

    @Override
    public HashMap<String, Float> getRegenTickModifiers() {
        return this.regenTickEnhancements;
    }

    @Override
    public void removeRegenTickModifier(String id) {
        if (this.regenTickEnhancements.containsKey(id)) {
            this.regenTickEnhancements.remove(id);
        }
        this.forceSync();
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public float getMaxMana() {
        float calculatedMaxMana = this.max_mana_baseline;
        for (Float f : this.maxManaEnhancements.values()) {
            calculatedMaxMana += f.floatValue();
        }
        return calculatedMaxMana;
    }

    @Override
    public float getBaselineMaxMana() {
        return this.max_mana_baseline;
    }

    @Override
    public void addMaxManaModifier(String id, float amount) {
        if (!this.maxManaEnhancements.containsKey(id) || this.maxManaEnhancements.get(id).floatValue() != amount) {
            this.maxManaEnhancements.put(id, Float.valueOf(amount));
            this.forceSync();
        }
    }

    @Override
    public HashMap<String, Float> getMaxManaModifiers() {
        return this.maxManaEnhancements;
    }

    @Override
    public void removeMaxManaModifier(String id) {
        if (this.maxManaEnhancements.containsKey(id)) {
            this.maxManaEnhancements.remove(id);
        }
        this.forceSync();
    }

    @Override
    public void clearMaxManaModifiers() {
        this.maxManaEnhancements.clear();
    }

    @Override
    public void tick(PlayerEntity attachedPlayer) {
        if (this.needsChronoExhaustion) {
            try {
                attachedPlayer.func_195064_c(new EffectInstance((Effect)EffectInit.CHRONO_EXHAUSTION.get(), 6000));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to apply chrono exhaustion to " + attachedPlayer != null ? attachedPlayer.func_200200_C_().getString() : "unknown player");
                ManaAndArtifice.LOGGER.catching((Throwable)ex);
            }
            finally {
                this.needsChronoExhaustion = false;
            }
        }
        if (this.portal_cooldown > 0) {
            --this.portal_cooldown;
        }
        if (this.orbActive) {
            this.orbMana -= 0.0833f;
        }
        if (attachedPlayer.func_233570_aj_()) {
            this.setAirCasts(0);
            this.setAirJumps(0);
        }
        if (this.mana == this.getMaxMana()) {
            return;
        }
        if (attachedPlayer.func_184812_l_()) {
            this.mana = this.getMaxMana();
        } else if (this.canRegenerateMana()) {
            attachedPlayer.func_71024_bL().func_75113_a(3.3333333E-4f);
            float regen_pct_per_tick = 1.0f / (float)this.getRegenTicks();
            float restored_mana = this.getMaxMana() * regen_pct_per_tick;
            if (attachedPlayer.func_71024_bL().func_75115_e() > 0.0f) {
                this.restore(restored_mana * 3.0f);
            } else {
                this.restore(restored_mana);
            }
        }
        ++this.tick_count;
        if (this.mana == this.getMaxMana()) {
            this.forceSync();
        }
    }

    @Override
    public boolean needsSync() {
        return this.tick_count >= 10;
    }

    @Override
    public boolean shouldSyncGrimoire() {
        return this.syncGrimoire;
    }

    @Override
    public void setSyncGrimoire() {
        this.syncGrimoire = true;
    }

    @Override
    public void clearSyncFlag() {
        this.tick_count = 0;
        this.syncGrimoire = false;
    }

    @Override
    public int getTeleportSalt() {
        return this.teleport_salt;
    }

    @Override
    public void resetTeleportSalt() {
        this.teleport_salt = (int)(Math.random() * 2.147483647E9);
    }

    @Override
    public void setTeleportSalt(int salt) {
        this.teleport_salt = salt;
    }

    @Override
    public void clearRememberedPoints() {
        this.rememberedPoints.clear();
        this.rememberedLooks.clear();
    }

    @Override
    public void addRememberedPoint(Vector3f point, Vector3f look) {
        this.rememberedPoints.add(point);
        this.rememberedLooks.add(look);
    }

    @Override
    public Vector3f[] getRememberedPoints() {
        Vector3f[] points = new Vector3f[this.rememberedPoints.size()];
        return this.rememberedPoints.toArray(points);
    }

    @Override
    public int getPortalCooldown() {
        return this.portal_cooldown;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.portal_cooldown = cooldown;
    }

    @Override
    public Vector3f getAverageLook() {
        if (this.rememberedLooks.size() == 0) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        float aX = 0.0f;
        float aY = 0.0f;
        float aZ = 0.0f;
        for (int i = 0; i < this.rememberedLooks.size(); ++i) {
            aX += this.rememberedLooks.get(i).func_195899_a();
            aY += this.rememberedLooks.get(i).func_195900_b();
            aZ += this.rememberedLooks.get(i).func_195902_c();
        }
        return new Vector3f(aX /= (float)this.rememberedLooks.size(), aY /= (float)this.rememberedLooks.size(), aZ /= (float)this.rememberedLooks.size());
    }

    @Override
    public Vector3f[] getRememberedLooks() {
        Vector3f[] points = new Vector3f[this.rememberedLooks.size()];
        return this.rememberedLooks.toArray(points);
    }

    @Override
    public Inventory getRiftInventory() {
        return this.riftInventory;
    }

    @Override
    public SpellInventory getGrimoireInventory() {
        return this.grimoireInventory;
    }

    @Override
    public int getMagicLevel() {
        return this.magicLevel;
    }

    @Override
    public void setMagicLevel(int level) {
        this.magicLevel = level;
        this.max_mana_baseline = 100 + 10 * level;
        this.forceSync();
    }

    private boolean canAdvanceToNextMagicLevel(IPlayerProgression progression) {
        return this.magicLevel < progression.getTier() * MAGIC_LEVELS_PER_MILESTONE;
    }

    @Override
    public int getXPForLevel(int level) {
        int baseline = 150;
        int amountPerLevel = (int)Math.pow(level - 1, 2.1f);
        return baseline + amountPerLevel;
    }

    private int getXPForNextLevel() {
        return this.getXPForLevel(this.magicLevel + 1);
    }

    @Override
    public int getMagicXP() {
        return this.magicXP;
    }

    @Override
    public void setMagicXP(int amount) {
        this.magicXP = amount;
    }

    @Override
    public void addMagicXP(int amount, PlayerEntity player, IPlayerProgression progression) {
        if (!this.canAdvanceToNextMagicLevel(progression)) {
            return;
        }
        this.magicXP += Math.max(amount, 1);
        if (this.magicXP > this.getXPForNextLevel()) {
            this.magicLevelUp(player, progression);
        }
    }

    @Override
    public float getAffinityDepth(Affinity affinity) {
        return this.affinityDepths.get((Object)affinity).floatValue();
    }

    @Override
    public void setAffinityDepth(Affinity affinity, float depth) {
        this.affinityDepths.put(affinity, Float.valueOf(depth));
        this.sortAffinities();
    }

    @Override
    public void shiftAffinity(Affinity affinity, float amount) {
        if (affinity == Affinity.UNKNOWN) {
            return;
        }
        affinity = affinity.getShiftAffinity();
        float halfshift = amount / 2.0f;
        for (Affinity aff : Affinity.values()) {
            if (aff == affinity) {
                this.affinityDepths.put(aff, Float.valueOf(Math.min(this.affinityDepths.get((Object)aff).floatValue() + amount, 100.0f)));
                continue;
            }
            this.affinityDepths.put(aff, Float.valueOf(Math.max(this.affinityDepths.get((Object)aff).floatValue() - halfshift, 0.0f)));
        }
        this.sortAffinities();
    }

    @Override
    public void magicLevelUp(PlayerEntity player, IPlayerProgression progression) {
        if (!this.canAdvanceToNextMagicLevel(progression)) {
            return;
        }
        if (!EventDispatcher.DispatchPlayerLevelUp(player, this.magicLevel + 1)) {
            return;
        }
        ++this.magicLevel;
        this.max_mana_baseline += 10.0f;
        this.mana = this.max_mana_baseline;
        this.magicXP = 0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SFX.Event.Player.MAGIC_LEVEL_UP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        this.forceSync();
    }

    @Override
    public int getAirCasts() {
        return this.air_casts;
    }

    @Override
    public int getAirCastLimit(PlayerEntity player) {
        int base = 2;
        if (player != null && ((SpellModifierRing)ItemInit.AIR_CAST_RING.get()).isEquippedAndHasMana((LivingEntity)player, 1.0f, false)) {
            ++base;
        }
        return base;
    }

    @Override
    public void setAirCasts(int casts) {
        this.air_casts = casts;
    }

    @Override
    public void incrementAirCasts(PlayerEntity player) {
        Optional t;
        ++this.air_casts;
        if (this.air_casts > 2 && player != null && this.air_casts < this.getAirCastLimit(player) && (t = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)player)).isPresent()) {
            ((SpellModifierRing)ItemInit.AIR_CAST_RING.get()).consumeMana((ItemStack)((ImmutableTriple)t.get()).right, 1.0f, player);
        }
    }

    @Override
    public int getAirJumps() {
        return this.air_jumps;
    }

    @Override
    public void incrementAirJumps(PlayerEntity source) {
        ++this.air_jumps;
    }

    @Override
    public void setAirJumps(int jumps) {
        this.air_jumps = jumps;
    }

    @Override
    public ChronoAnchorData getChronoAnchorData() {
        return this.chronoData;
    }

    @Override
    public Vector3d getLiftPosition() {
        return this.liftPosition;
    }

    @Override
    public void setLiftPosition(Vector3d pos) {
        this.liftPosition = pos;
    }

    @Override
    public boolean didAllowFlying() {
        return this.didAllowFlight;
    }

    @Override
    public void setDidAllowFlying(boolean flight) {
        this.didAllowFlight = flight;
    }

    private void sortAffinities() {
        LinkedList<Map.Entry<Affinity, Float>> list = new LinkedList<Map.Entry<Affinity, Float>>(this.affinityDepths.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Affinity, Float>>(){

            @Override
            public int compare(Map.Entry<Affinity, Float> o1, Map.Entry<Affinity, Float> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<Affinity, Float> temp = new LinkedHashMap<Affinity, Float>();
        for (Map.Entry entry : list) {
            temp.put((Affinity)((Object)entry.getKey()), (Float)entry.getValue());
        }
        this.affinityDepths = temp;
    }

    @Override
    public Map<Affinity, Float> getSortedAffinityDepths() {
        return (Map)this.affinityDepths.clone();
    }

    @Override
    public void forceSync() {
        this.tick_count = 10;
    }

    @Override
    public float getRegenModifier() {
        float mod = 1.0f;
        for (float value : this.regenTickEnhancements.values()) {
            mod += mod * value;
        }
        return mod;
    }

    @Override
    public boolean canRegenerateMana() {
        return this.getRegenModifier() > 0.0f;
    }

    @Override
    public void setNeedsChronoExhaustion() {
        this.needsChronoExhaustion = true;
    }

    @Override
    public SpellInventory getRoteInventory() {
        return this.roteInventory;
    }

    @Override
    public boolean getHadWizardSight() {
        return this.hadWizardSight;
    }

    @Override
    public void setHadWizardSight(boolean had) {
        this.hadWizardSight = had;
    }

    @Override
    public ICantripData getCantripData() {
        return this.cantripData;
    }

    @Override
    public int bankArmorRepair(int slot, float amount) {
        if (!this.armor_repair_accumulation.containsKey(slot)) {
            this.armor_repair_accumulation.put(slot, Float.valueOf(0.0f));
        }
        float newAmt = this.armor_repair_accumulation.get(slot).floatValue() + amount;
        int returnAmt = (int)Math.floor(newAmt);
        this.armor_repair_accumulation.put(slot, Float.valueOf(newAmt -= (float)returnAmt));
        return returnAmt;
    }

    @Override
    public HashMap<Integer, Float> getBankedArmorRepair() {
        return this.armor_repair_accumulation;
    }

    @Override
    public void setBankedArmorRepair(HashMap<Integer, Float> data) {
        this.armor_repair_accumulation = data;
    }

    @Override
    public void setModifierPressed(boolean pressed) {
        this.modifierPressed = pressed;
    }

    @Override
    public boolean isModifierPressed() {
        return this.modifierPressed;
    }
}

