/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.progression;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.progression.ProgressionEventHandler;
import com.ma.progression.ProgressionHelper;
import com.ma.tools.math.MathUtilities;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class PlayerProgression
implements IPlayerProgression {
    public static final int MAX_TIERS = 5;
    private int tier = 1;
    private Faction allied_faction;
    private int faction_standing;
    private List<ResourceLocation> metTierProgressions;
    private long lastRaidCheckTime;
    private double raidChance;
    private boolean raidFlag;
    private boolean dirty;
    private long raid_time_salt = 0L;
    private String lastCodexEntry = "";
    private String lastCodexRecipeType = "";
    private ResourceLocation[] lastCodexRecipeLocations = new ResourceLocation[0];

    public PlayerProgression() {
        this.allied_faction = Faction.NONE;
        this.metTierProgressions = new ArrayList<ResourceLocation>();
        this.raid_time_salt = (long)(Math.random() * 12000.0);
        this.setDirty();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier, @Nullable PlayerEntity player) {
        if (this.tier == tier) {
            return;
        }
        this.tier = MathUtilities.clamp(tier, 1, 5);
        this.metTierProgressions.clear();
        if (player != null) {
            ProgressionEventHandler.confirmExistingAdvancements(player);
        }
        this.setDirty();
    }

    @Override
    public Faction getAlliedFaction() {
        return this.allied_faction;
    }

    @Override
    public boolean hasAlliedFaction() {
        return this.allied_faction != Faction.NONE;
    }

    @Override
    public void setAlliedFaction(Faction faction) {
        this.allied_faction = faction;
        this.setDirty();
    }

    @Override
    public int getFactionStanding() {
        return this.faction_standing;
    }

    @Override
    public void setFactionStanding(int standing) {
        this.faction_standing = standing;
        this.setDirty();
    }

    @Override
    public boolean needsSync() {
        return this.dirty;
    }

    @Override
    public void clearSyncFlag() {
        this.dirty = false;
    }

    @Override
    public void addTierProgressionComplete(ResourceLocation complededCondition) {
        if (!this.metTierProgressions.contains(complededCondition)) {
            this.metTierProgressions.add(complededCondition);
            this.setDirty();
        }
    }

    @Override
    public float getTierProgress() {
        return MathUtilities.clamp01((float)this.metTierProgressions.size() / (float)ProgressionHelper.getCompletePerTier(this.getTier()));
    }

    @Override
    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.metTierProgressions;
    }

    @Override
    public void setTierProgression(List<ResourceLocation> complededCondition) {
        this.metTierProgressions.clear();
        this.metTierProgressions.addAll(complededCondition);
        this.setDirty();
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public long getLastRaidCheckTime() {
        return this.lastRaidCheckTime;
    }

    @Override
    public void setLastRaidCheckTime(long time) {
        this.lastRaidCheckTime = time;
    }

    @Override
    public double getRaidChance() {
        return this.raidChance;
    }

    @Override
    public void setRaidChance(double chance) {
        this.raidChance = chance;
        if (this.raidChance == 1.0) {
            this.raidFlag = true;
        } else if (this.raidChance == 0.0) {
            this.raidFlag = false;
        }
    }

    @Override
    public int getRelativeRaidStrength(PlayerEntity player) {
        int strength = 0;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            strength = magic.getMagicLevel();
        }
        return strength *= this.tier;
    }

    @Override
    public void incrementRaidChance(PlayerEntity player) {
        if (this.tier < 3) {
            return;
        }
        long timeDiff = Math.abs(player.field_70170_p.func_82737_E() - this.lastRaidCheckTime);
        if (timeDiff < 24000L + this.raid_time_salt) {
            return;
        }
        this.raid_time_salt = (long)(Math.random() * 12000.0);
        double baseline = (Double)GeneralModConfig.RAID_CHANCE_BASE.get();
        double tierBoost = (Double)GeneralModConfig.RAID_CHANCE_TIER.get();
        this.raidChance += baseline + tierBoost * (double)(this.tier - 3);
        this.lastRaidCheckTime = player.field_70170_p.func_82737_E();
        if (Math.random() < this.raidChance) {
            this.raidFlag = true;
        }
    }

    @Override
    public boolean canBeRaided(PlayerEntity player) {
        return this.raidFlag;
    }

    @Override
    public String getLastCodexEntry() {
        return this.lastCodexEntry;
    }

    @Override
    public void setLastCodexEntry(String key) {
        this.lastCodexEntry = key;
    }

    @Override
    public AbstractMap.SimpleEntry<String, ResourceLocation[]> getLastCodexRecipe() {
        return new AbstractMap.SimpleEntry<String, ResourceLocation[]>(this.lastCodexRecipeType, this.lastCodexRecipeLocations);
    }

    @Override
    public void setLastCodexRecipe(String recipe, ResourceLocation[] rLocs) {
        this.lastCodexRecipeType = recipe;
        this.lastCodexRecipeLocations = rLocs;
    }

    @Override
    public int getTierMaxComplexity() {
        if (this.getTier() == 5) {
            return 999999;
        }
        return 20 * this.getTier();
    }
}

