/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.worlddata;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.capabilities.worlddata.RitualTeleportLocation;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;

public class WorldMagicStorage
implements Capability.IStorage<IWorldMagic> {
    private final String KEY_TELEPORT_LOCATIONS = "teleport_locations";
    private final String KEY_TELEPORT_LOCATION_COUNT = "teleport_locations_size";
    private final String KEY_TELEPORT_LOCATION_PREFIX = "teleport_location_";
    private final String KEY_RUNES = "runes";
    private final String KEY_WARDING_CANDLE_LOCATIONS = "warding_candle_locations";

    public INBT writeNBT(Capability<IWorldMagic> capability, IWorldMagic instance, Direction side) {
        UUID[] playerIDs;
        CompoundNBT nbt_main = new CompoundNBT();
        IRitualTeleportLocation[] locations = instance.getAllTeleportLocations();
        CompoundNBT teleport_locations = new CompoundNBT();
        teleport_locations.func_74768_a("teleport_locations_size", locations.length);
        for (int i = 0; i < locations.length; ++i) {
            CompoundNBT teleport_location_nbt = new CompoundNBT();
            ((RitualTeleportLocation)locations[i]).writeToNBT(teleport_location_nbt);
            teleport_locations.func_218657_a("teleport_location_" + i, (INBT)teleport_location_nbt);
        }
        nbt_main.func_218657_a("teleport_locations", (INBT)teleport_locations);
        ListNBT runes = new ListNBT();
        for (UUID playerID : playerIDs = instance.getKnownPlayersWithRunes()) {
            UUID[] known_runes;
            if (playerID == null || (known_runes = instance.getKnownRunesForPlayer(playerID)).length == 0) continue;
            CompoundNBT playerRuneData = new CompoundNBT();
            playerRuneData.func_74778_a("playerID", playerID.toString());
            ListNBT runeIDs = new ListNBT();
            for (UUID runeID : known_runes) {
                runeIDs.add((Object)StringNBT.func_229705_a_((String)runeID.toString()));
            }
            playerRuneData.func_218657_a("runeIDs", (INBT)runeIDs);
            runes.add((Object)playerRuneData);
        }
        nbt_main.func_218657_a("runes", (INBT)runes);
        nbt_main.func_218657_a("warding_candle_locations", (INBT)new LongArrayNBT(instance.getAllWardingCandleLocations()));
        return nbt_main;
    }

    public void readNBT(Capability<IWorldMagic> capability, IWorldMagic instance, Direction side, INBT nbt) {
        if (!(nbt instanceof CompoundNBT)) {
            ManaAndArtifice.LOGGER.error("World Magic NBT passed back not an instance of CompoundNBT - all save data was NOT loaded!");
            return;
        }
        CompoundNBT nbt_main = (CompoundNBT)nbt;
        if (nbt_main.func_74764_b("teleport_locations")) {
            CompoundNBT teleport_locations = nbt_main.func_74775_l("teleport_locations");
            if (teleport_locations.func_74764_b("teleport_locations_size")) {
                int count = teleport_locations.func_74762_e("teleport_locations_size");
                for (int i = 0; i < count; ++i) {
                    if (teleport_locations.func_74764_b("teleport_location_" + i)) {
                        CompoundNBT teleport_location_nbt = teleport_locations.func_74775_l("teleport_location_" + i);
                        RitualTeleportLocation loc = RitualTeleportLocation.fromNBT(teleport_location_nbt);
                        if (loc != null) {
                            instance.setRitualTeleportLocation(loc);
                            continue;
                        }
                        ManaAndArtifice.LOGGER.error("Teleport Location NBT failed to load at index " + i + " - this teleport location was NOT loaded!");
                        continue;
                    }
                    ManaAndArtifice.LOGGER.error("Teleport Locations NBT does not contain teleport location data key " + i + " - this teleport location was NOT loaded!");
                }
            } else {
                ManaAndArtifice.LOGGER.error("Teleport Locations NBT does not contain teleport locations count key - teleport location save data was NOT loaded!");
            }
            ManaAndArtifice.LOGGER.info("Teleport Locations loaded successfully!");
        } else {
            ManaAndArtifice.LOGGER.error("World Magic NBT does not contain teleport locations key - teleport location save data was NOT loaded!");
        }
        if (nbt_main.func_74764_b("runes")) {
            ListNBT runes = nbt_main.func_150295_c("runes", 10);
            runes.forEach(inbt_player_runes -> {
                CompoundNBT player_rune_nbt = (CompoundNBT)inbt_player_runes;
                if (player_rune_nbt.func_74764_b("playerID") && player_rune_nbt.func_74764_b("runeIDs")) {
                    try {
                        UUID playerID = UUID.fromString(player_rune_nbt.func_74779_i("playerID"));
                        ListNBT player_known_runes = player_rune_nbt.func_150295_c("runeIDs", 8);
                        for (int i = 0; i < player_known_runes.size(); ++i) {
                            UUID runeID = null;
                            try {
                                runeID = UUID.fromString(player_known_runes.func_150307_f(i));
                            }
                            catch (Exception ex) {
                                ManaAndArtifice.LOGGER.error("Failed to load player rune data");
                                ManaAndArtifice.LOGGER.catching((Throwable)ex);
                            }
                            if (runeID == null) continue;
                            instance.addUnreferencedRune(playerID, runeID);
                        }
                    }
                    catch (Exception ex) {
                        ManaAndArtifice.LOGGER.error("Failed to load player rune data");
                        ManaAndArtifice.LOGGER.catching((Throwable)ex);
                    }
                }
            });
            ManaAndArtifice.LOGGER.info("Known Runes loaded successfully!");
        } else {
            ManaAndArtifice.LOGGER.error("World Magic NBT does not contain known runes key - known rune save data was NOT loaded!  This is expected if you're upgrading your world from an M&A version less than 1.0.8.2.");
        }
        if (nbt_main.func_150297_b("warding_candle_locations", 12)) {
            instance.setWardingCandleLocations(Arrays.stream(nbt_main.func_197645_o("warding_candle_locations")).boxed().collect(Collectors.toList()));
        }
    }
}

