/*
 * Decompiled with CFR 0.152.
 */
package com.ma.commands;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandRaid {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"factionRaid").requires(commandSource -> commandSource.func_197034_c(2))).executes(context -> CommandRaid.factionRaid((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandRaid.factionRaid((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))));
    }

    private static int factionRaid(CommandSource source, Collection<ServerPlayerEntity> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayerEntity spe : players) {
            IPlayerProgression progression = (IPlayerProgression)spe.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return 0;
            }
            if (progression.getTier() < 3) {
                return 0;
            }
            progression.setRaidChance(1.0);
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.factionRaid.success", new Object[]{players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.factionRaid.success", new Object[]{players.size()}), true);
        }
        return 1;
    }
}

