/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class GeneralClientConfig {
    public static ForgeConfigSpec.IntValue CODEX_BACK_STYLE;
    public static ForgeConfigSpec.IntValue HIDE_HUD_MODE;
    public static ForgeConfigSpec.IntValue HUD_POSITION;
    public static ForgeConfigSpec.IntValue PINNED_RECIPE_SCALE;
    public static ForgeConfigSpec.BooleanValue FANCY_MAGELIGHTS;
    public static ForgeConfigSpec.BooleanValue RITUAL_TIP_SHOWN;
    public static ForgeConfigSpec.BooleanValue PIN_TIP_SHOWN;

    public GeneralClientConfig(ForgeConfigSpec.Builder clientBuilder) {
        GeneralClientConfig.init_codex(clientBuilder);
        GeneralClientConfig.init_hud(clientBuilder);
        GeneralClientConfig.init_performance_options(clientBuilder);
        GeneralClientConfig.init_did_you_know(clientBuilder);
    }

    private static void init_codex(ForgeConfigSpec.Builder clientBuilder) {
        clientBuilder.comment("Mana and Artifice // Codex Settings").push("ma_codex_settings");
        CODEX_BACK_STYLE = clientBuilder.comment("Change the 'back' behaviour of the Codex (which buttons will cause it to go back, and which will close it entirely).").comment(new String[]{"0: UI buttons only.  Escape closes the codex entirely.", "1: UI buttons / escape.  Escape backs the codex out until the index, then closes it.", "2: UI buttons / right mouse.  Right mouse backs the codex out until the index. Escape closes the codex entirely.", "3: UI buttons / escape / right mouse.  Escape or right mouse backs the codex out until the index, then closes it."}).defineInRange("codexBackStyle", 0, 0, 3);
        clientBuilder.pop();
    }

    private static void init_hud(ForgeConfigSpec.Builder clientBuilder) {
        clientBuilder.comment("Mana and Artifice // HUD Settings").push("ma_hud_settings");
        HIDE_HUD_MODE = clientBuilder.comment("Change the behaviour of the HUD.").comment(new String[]{"0: Always visible.", "1: Hidden unless holding a mana consuming/restoring item.", "2: Always hidden."}).defineInRange("hudMode", 0, 0, 2);
        HUD_POSITION = clientBuilder.comment("Change the position of the HUD:").comment(new String[]{"1: Top Left", "2: Top Center", "3: Top Right", "4: Middle Right", "5: Bottom Right", "6: Bottom Center", "7: Bottom Left", "8: Middle Left"}).defineInRange("hudPosition", 1, 1, 8);
        PINNED_RECIPE_SCALE = clientBuilder.comment("Change the size of pinned recipes.").defineInRange("pinnedRecipeSize", 1, 1, 3);
        clientBuilder.pop();
    }

    private static void init_performance_options(ForgeConfigSpec.Builder clientBuilder) {
        clientBuilder.comment("Mana and Artifice // Performance Settings").push("ma_performance");
        FANCY_MAGELIGHTS = clientBuilder.comment("Enable fancy magelights (disable this if you're getting FPS issues)").define("ma_fancy_magelights", true);
        clientBuilder.pop();
    }

    private static void init_did_you_know(ForgeConfigSpec.Builder clientBuilder) {
        clientBuilder.comment("Mana and Artifice // Help Tips Settings").push("ma_helptips");
        RITUAL_TIP_SHOWN = clientBuilder.define("ma_ritual_tip", false);
        PIN_TIP_SHOWN = clientBuilder.define("ma_pin_tip", false);
        clientBuilder.pop();
    }
}

