/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class GeneralModConfig {
    public static ForgeConfigSpec.BooleanValue MA_MODIFY_VILLAGER_TRADES;
    public static ForgeConfigSpec.DoubleValue RAID_CHANCE_BASE;
    public static ForgeConfigSpec.DoubleValue RAID_CHANCE_TIER;
    public static ForgeConfigSpec.IntValue RAID_SPAWN_ATTEMPTS;
    public static ForgeConfigSpec.BooleanValue MA_SPAWN_STRUCTURES;
    public static ForgeConfigSpec.BooleanValue MA_GRADUAL_TIME_CHANGE;
    public static ForgeConfigSpec.ConfigValue<String> MA_WARD_BLACKLIST;

    public static void init(ForgeConfigSpec.Builder serverBuilder) {
        GeneralModConfig.initGeneralOptions(serverBuilder);
        GeneralModConfig.initVillagerTradeConfig(serverBuilder);
        GeneralModConfig.initFactionRaidConfig(serverBuilder);
    }

    private static void initVillagerTradeConfig(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Villager Modification").push("ma_villager_modification");
        MA_MODIFY_VILLAGER_TRADES = serverBuilder.comment("Adjust librarian villagers to not have enchanted books until tier 3.  This is done for balancing and to remove the exploit of rolling librarians for cheap enchants. [true / false]").define("modifyVillagerTrades", true);
        serverBuilder.pop();
    }

    private static void initFactionRaidConfig(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Faction Raids").comment("Raids are based on a chance value.  The value is increased each day there is not a raid.  If the chance hits a total of 1.0 or greater, it's a guaranteed raid.  The chance resets after a raid successfully spawns.").push("ma_faction_raids");
        RAID_CHANCE_BASE = serverBuilder.comment("Adjust the base amount per day that the chance to be raided goes up for each player.").defineInRange("raidBaselineIncrease", 0.05, 0.0, 1.0);
        RAID_CHANCE_TIER = serverBuilder.comment("Adjust the amount per day that the chance to be raided goes up for each player based on their tier above 3 (this value * (tier-3)).  This is added to the baseline.").defineInRange("raidTierIncrease", 0.05, 0.0, 1.0);
        RAID_SPAWN_ATTEMPTS = serverBuilder.comment("How many attempts (within a 20x20x5 box centered on the player in question) should the game make to spawn a raid?  Note this will be re-attempted every 1000 ticks until a successful spawn is made.  If you're lagging due to raid spawn attempts, lower this setting.").defineInRange("raidSpawnAttempts", 100, 1, 1000);
        serverBuilder.pop();
    }

    private static void initGeneralOptions(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // General Options").push("ma_general_options");
        MA_GRADUAL_TIME_CHANGE = serverBuilder.comment("Rituals of Aurora and Eventide by default will change time gradually for a prettier effect.  However this isn't without its performance impacts, and this can be toggled off by setting this to false, making the transition instant like the /time set commands. [true / false]").define("gradualTimeChange", true);
        MA_WARD_BLACKLIST = serverBuilder.comment("A comma separated list of entity IDs that the warding candle should ignore, regardless of detection (use this if it's stopping you from something you think it shouldn't; this isn't to expand what it will block)").define("wardingCandleBlacklist", (Object)"");
        serverBuilder.pop();
    }
}

