/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs;

import com.ma.api.particles.ParticleInit;
import com.ma.entities.EntityInit;
import com.ma.items.ItemInit;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBubbleBoat
extends BoatEntity {
    private static final DataParameter<Byte> UPGRADE = EntityDataManager.func_187226_a(EntityBubbleBoat.class, (IDataSerializer)DataSerializers.field_187191_a);
    private float boatRotation = 0.0f;
    private float prevBoatRotation = 0.0f;

    public EntityBubbleBoat(EntityType<? extends EntityBubbleBoat> p_i50129_1_, World p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.field_70156_m = true;
    }

    public float getBoatRotation(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevBoatRotation, (float)this.boatRotation);
    }

    public EntityBubbleBoat(World worldIn, double x, double y, double z) {
        this((EntityType<? extends EntityBubbleBoat>)((EntityType)EntityInit.BUBBLE_BOAT.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public EntityBubbleBoat setBrimstone() {
        this.field_70180_af.func_187227_b(UPGRADE, (Object)1);
        return this;
    }

    public boolean isBrimstone() {
        return (Byte)this.field_70180_af.func_187225_a(UPGRADE) == 1;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(UPGRADE, (Object)0);
    }

    public void func_70071_h_() {
        this.underwaterControl();
        this.handleSpecialLavaProperties();
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.func_184188_bt().size() > 0 && this.field_184469_aF != BoatEntity.Status.IN_AIR && this.field_184469_aF != BoatEntity.Status.ON_LAND) {
            float RADIUS = 3.0f;
            Vector3d OFFSET = new Vector3d(-1.0, -0.25, -1.0);
            Vector3d VELOCITY = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
            int amount = (int)Math.ceil(this.func_213322_ci().func_72433_c() * 25.0);
            for (int i = 0; i < amount; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.WATER.get(), OFFSET.field_72450_a + this.func_226277_ct_() + Math.random() * (double)RADIUS, OFFSET.field_72448_b + this.func_226278_cu_() + Math.random() * (double)RADIUS, OFFSET.field_72449_c + this.func_226281_cx_() + Math.random() * (double)RADIUS, VELOCITY.field_72450_a, VELOCITY.field_72448_b, VELOCITY.field_72449_c);
            }
        }
        this.prevBoatRotation = this.boatRotation;
        if (this.func_184188_bt().size() > 0) {
            double motionMagnitude = this.func_213322_ci().func_72433_c() * 0.25;
            if (motionMagnitude > 0.001) {
                this.boatRotation = (float)((double)this.boatRotation - motionMagnitude);
                this.boatRotation = (float)((double)this.boatRotation % (Math.PI * 2));
            }
        } else {
            double halfPi = 1.5707963267948966;
            this.boatRotation -= 0.1f;
            if ((double)Math.abs(this.boatRotation) % halfPi <= (double)0.1f) {
                this.boatRotation = 0.0f;
                this.prevBoatRotation = 0.0f;
            }
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public boolean func_180427_aV() {
        if (this.isBrimstone()) {
            return true;
        }
        return super.func_180427_aV();
    }

    public boolean func_230279_az_() {
        if (this.isBrimstone()) {
            return true;
        }
        return super.func_230279_az_();
    }

    public boolean func_90999_ad() {
        if (this.isBrimstone()) {
            return false;
        }
        return super.func_90999_ad();
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.func_180799_ab() && this.isBrimstone()) {
            this.field_70143_R = 0.0f;
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    private void underwaterControl() {
        this.field_184474_h = 0.0f;
        if ((this.field_184469_aF == BoatEntity.Status.UNDER_WATER || this.field_184469_aF == BoatEntity.Status.UNDER_FLOWING_WATER) && this.func_184188_bt().size() > 0) {
            double yVel = Math.min(this.func_213322_ci().field_72448_b + (double)0.2f, 2.0);
            this.func_213317_d(new Vector3d(this.func_213322_ci().field_72450_a, yVel, this.func_213322_ci().field_72449_c));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Item func_184455_j() {
        return (Byte)this.field_70180_af.func_187225_a(UPGRADE) == 0 ? (Item)ItemInit.BUBBLE_BOAT.get() : (Item)ItemInit.BRIMSTONE_BOAT.get();
    }

    private void handleSpecialLavaProperties() {
        if (this.func_180799_ab()) {
            this.field_70138_W = 2.0f;
            this.func_184188_bt().forEach(e -> {
                if (e instanceof LivingEntity && (((LivingEntity)e).func_70660_b(Effects.field_76426_n) == null || ((LivingEntity)e).func_70660_b(Effects.field_76426_n).func_76459_b() < 20)) {
                    ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76426_n, 200));
                }
            });
            this.field_70122_E = false;
            ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b * 0.5 + 0.05, this.func_213322_ci().field_72449_c);
            }
        } else {
            this.field_70138_W = 1.0f;
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 1;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double func_70042_X() {
        return 0.3;
    }
}

