/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs;

import com.ma.api.particles.ParticleInit;
import com.ma.entities.EntityInit;
import com.ma.items.ItemInit;
import com.ma.tools.InventoryUtilities;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityMagicBroom
extends GolemEntity {
    private static final float detection_radius = 16.0f;
    private static final float detection_height = 2.0f;
    private static final float max_distance_from_container = 48.0f;
    private static final float movement_speed = 0.4f;
    private static final Predicate<ItemEntity> ITEM_SELECTOR = e -> !e.func_174874_s() && e.func_70089_S();
    private int deposit_counter = 0;
    private boolean depositing = false;
    private static final DataParameter<BlockPos> CONTAINER_POSITION = EntityDataManager.func_187226_a(EntityMagicBroom.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final String KEY_TARGETPOS = "magic_broom_targetPosition";
    private float moveCounter = 0.0f;
    private float moveRotation = 0.0f;

    public EntityMagicBroom(EntityType<? extends GolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.field_70138_W = 2.0f;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0);
    }

    private void updateRotations() {
        if (Math.abs(this.func_213322_ci().func_72433_c()) > (double)0.1f) {
            this.moveCounter += 0.3f;
            this.moveRotation = (float)Math.sin(this.moveCounter) - (float)Math.sin(this.moveCounter - 1.0f);
            if ((int)this.moveCounter % 3 == 0 && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187579_bV, SoundCategory.NEUTRAL, 0.25f, 1.0f, false);
            }
        } else {
            this.moveCounter = 1.57f;
            if (this.moveRotation > 0.0f) {
                this.moveRotation -= 0.1f;
                if (this.moveRotation < 0.0f) {
                    this.moveRotation = 0.0f;
                }
            } else if (this.moveRotation < 0.0f) {
                this.moveRotation += 0.1f;
                if (this.moveRotation > 0.0f) {
                    this.moveRotation = 0.0f;
                }
            }
        }
    }

    public float getRotation() {
        return this.moveRotation;
    }

    public EntityMagicBroom(World worldIn) {
        super((EntityType)EntityInit.MAGIC_BROOM.get(), worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new DepositItemsGoal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CONTAINER_POSITION, (Object)BlockPos.field_177992_a);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (player.func_225608_bj_() && !this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.func_98053_h(false);
            this.remove(false);
            this.func_98053_h(false);
            this.func_199701_a_(new ItemStack((IItemProvider)ItemInit.MAGIC_BROOM.get()));
            this.func_213345_d(this.func_189748_bU());
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public BlockPos getContainerPosition() {
        return (BlockPos)this.field_70180_af.func_187225_a(CONTAINER_POSITION);
    }

    public void setContainerPosition(BlockPos pos) {
        this.field_70180_af.func_187227_b(CONTAINER_POSITION, (Object)pos);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack curStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (curStack.func_190926_b()) {
            return true;
        }
        return curStack.func_77973_b() == stack.func_77973_b() && curStack.func_190916_E() <= curStack.func_77976_d() - stack.func_190916_E();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateRotations();
        if (this.field_70170_p.field_72995_K && Math.abs(this.func_213322_ci().func_72433_c()) > (double)0.1f) {
            float particle_spread = 0.05f;
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)0.025f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.DUST.get(), this.func_226277_ct_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226278_cu_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226281_cx_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
        if (this.func_70089_S()) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0))) {
                if (!itementity.func_70089_S() || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                this.func_175445_a(itementity);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack mhStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        ItemStack groundStack = itemEntity.func_92059_d();
        if (mhStack.func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, groundStack);
            this.func_71001_a((Entity)itemEntity, mhStack.func_190916_E());
            itemEntity.func_70106_y();
        } else if (groundStack.func_77969_a(mhStack)) {
            int space = mhStack.func_77976_d() - mhStack.func_190916_E();
            int qtyCollected = Math.min(space, groundStack.func_190916_E());
            ItemStack pickupStack = groundStack.func_77979_a(qtyCollected);
            mhStack.func_190920_e(mhStack.func_190916_E() + pickupStack.func_190916_E());
            this.func_184201_a(EquipmentSlotType.MAINHAND, mhStack);
            if (groundStack.func_190916_E() <= 0) {
                itemEntity.func_70106_y();
            } else {
                itemEntity.func_92058_a(groundStack);
            }
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b()) {
            this.func_199701_a_(itemstack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockPos target = this.getContainerPosition();
        CompoundNBT targetPos = new CompoundNBT();
        targetPos.func_74768_a("x", target.func_177958_n());
        targetPos.func_74768_a("y", target.func_177956_o());
        targetPos.func_74768_a("z", target.func_177952_p());
        compound.func_218657_a(KEY_TARGETPOS, (INBT)targetPos);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(KEY_TARGETPOS)) {
            CompoundNBT targetPos = compound.func_74775_l(KEY_TARGETPOS);
            this.setContainerPosition(new BlockPos(targetPos.func_74762_e("x"), targetPos.func_74762_e("y"), targetPos.func_74762_e("z")));
        }
    }

    class DepositItemsGoal
    extends Goal {
        private TileEntity targetTE;
        private boolean abort = false;

        public DepositItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.abort) {
                this.abort = false;
                return false;
            }
            if (EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            return EntityMagicBroom.this.func_233580_cy_().func_218141_a((Vector3i)EntityMagicBroom.this.getContainerPosition(), 48.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityMagicBroom.this.depositing = false;
            EntityMagicBroom.this.deposit_counter = 10;
        }

        public void func_75249_e() {
            BlockPos target = EntityMagicBroom.this.getContainerPosition();
            EntityMagicBroom.this.func_70661_as().func_75492_a((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p(), (double)0.4f);
            this.targetTE = EntityMagicBroom.this.func_130014_f_().func_175625_s(EntityMagicBroom.this.getContainerPosition());
            this.abort = false;
        }

        public void func_75246_d() {
            if (this.targetTE == null) {
                this.abort = true;
                return;
            }
            LazyOptional handler = this.targetTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)EntityMagicBroom.this.field_70170_p));
            if (!handler.isPresent()) {
                this.abort = true;
                return;
            }
            ItemStack activeStack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
            BlockPos target = EntityMagicBroom.this.getContainerPosition();
            double dist = EntityMagicBroom.this.func_70092_e(target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
            if (dist < 4.0) {
                EntityMagicBroom.this.field_70699_by.func_75499_g();
                if (!EntityMagicBroom.this.depositing) {
                    EntityMagicBroom.this.depositing = true;
                    if (this.targetTE instanceof IInventory) {
                        ((IInventory)this.targetTE).func_174889_b((PlayerEntity)player);
                    }
                }
                if (EntityMagicBroom.this.deposit_counter <= 0) {
                    EntityMagicBroom.this.deposit_counter = 10;
                    ItemStack insertStack = activeStack.func_77946_l();
                    insertStack.func_190920_e(1);
                    if (InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), insertStack)) {
                        activeStack.func_190918_g(1);
                    }
                    if (insertStack.func_190926_b()) {
                        EntityMagicBroom.this.depositing = false;
                    }
                } else {
                    EntityMagicBroom.this.deposit_counter--;
                }
                if (!EntityMagicBroom.this.depositing && this.targetTE instanceof IInventory) {
                    ((IInventory)this.targetTE).func_174886_c((PlayerEntity)player);
                }
            } else {
                EntityMagicBroom.this.func_70661_as().func_75492_a((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p(), (double)0.4f);
            }
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EntityMagicBroom.this.depositing) {
                return false;
            }
            List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0), e -> {
                if (EntityMagicBroom.this.func_70685_l((Entity)e)) {
                    return ITEM_SELECTOR.test(e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                ItemStack stack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
                if (stack.func_190916_E() == stack.func_77976_d()) {
                    return false;
                }
                if (stack.func_190926_b()) {
                    return true;
                }
                for (ItemEntity item : list) {
                    if (item.func_92059_d().func_77973_b() != EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b()) continue;
                    return true;
                }
            }
            return false;
        }

        public void func_75246_d() {
            ItemStack itemstack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0), e -> {
                    if (EntityMagicBroom.this.func_70685_l((Entity)e)) {
                        return ITEM_SELECTOR.test(e);
                    }
                    return false;
                });
                if (itemstack.func_190926_b() && !list.isEmpty()) {
                    EntityMagicBroom.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)0.4f);
                }
            } else {
                List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0), item -> !item.func_174874_s() && item.func_70089_S() && item.func_92059_d().func_77973_b() == itemstack.func_77973_b() && EntityMagicBroom.this.func_70685_l((Entity)item));
                if (!list.isEmpty() && itemstack.func_190916_E() < itemstack.func_77976_d() && !EntityMagicBroom.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)0.4f)) {
                    Direction offset = Direction.func_176731_b((int)((int)(Math.random() * 4.0)));
                    BlockPos offsetPos = EntityMagicBroom.this.func_233580_cy_().func_177982_a(offset.func_82601_c(), offset.func_96559_d(), offset.func_82599_e());
                    EntityMagicBroom.this.func_70661_as().func_75492_a((double)offsetPos.func_177958_n(), (double)offsetPos.func_177956_o(), (double)offsetPos.func_177952_p(), (double)0.4f);
                }
            }
        }

        public void func_75249_e() {
            List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 1.0, 16.0), e -> {
                if (EntityMagicBroom.this.func_70685_l((Entity)e)) {
                    return ITEM_SELECTOR.test(e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                EntityMagicBroom.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)0.4f);
            }
        }
    }
}

