/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.math.MathUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class ConstructBreed
extends ConstructCommand {
    private static final int MAX_SIZE = 32;
    private static final int MIN_ANIMALS = 2;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = this.getInteractTime(ConstructCapability.CARRY);
    private AxisAlignedBB breedArea = null;
    private ArrayList<AnimalEntity> currentBreedTargets = new ArrayList();
    private int currentBreedIndex = 0;
    private boolean tooBig = false;

    public ConstructBreed(EntityAnimatedConstruct construct) {
        super(construct);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.getValidHeldBreedItems().size() == 0) {
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_no_items", new Object[0]), false);
            }
            this.isFinished = true;
            return;
        }
        if (this.currentBreedTargets.size() < 2 && !this.locateBreedTarget()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_no_target", new Object[0]), false);
            this.isFinished = true;
            return;
        }
        this.moveEntityTarget = (Entity)this.currentBreedTargets.get(this.currentBreedIndex);
        if (this.doMove() && this.breedTarget()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_success", this.translate((Entity)this.currentBreedTargets.get(this.currentBreedIndex))), false);
            ++this.currentBreedIndex;
            if (this.currentBreedIndex >= this.currentBreedTargets.size()) {
                this.isFinished = true;
                this.isSuccess = true;
                return;
            }
        }
    }

    private boolean locateBreedTarget() {
        this.currentBreedIndex = 0;
        HashMap locatedEntities = new HashMap();
        this.construct.field_70170_p.func_175647_a(AnimalEntity.class, this.breedArea, e -> e.func_70089_S() && !e.func_70631_g_() && e.func_70874_b() == 0 && this.getHeldItems().stream().anyMatch(i -> e.func_70877_b(i))).forEach(e -> {
            if (!locatedEntities.containsKey(e.func_200600_R())) {
                locatedEntities.put(e.func_200600_R(), new ArrayList<AnimalEntity>(Arrays.asList(e)));
            } else {
                ((List)locatedEntities.get(e.func_200600_R())).add(e);
            }
        });
        Optional<List> target = locatedEntities.entrySet().stream().filter(e -> ((List)e.getValue()).size() >= 2).filter(e -> !this.getHeldBreedItem((AnimalEntity)((List)e.getValue()).get(0)).func_190926_b()).map(e -> (List)e.getValue()).findAny();
        if (!target.isPresent()) {
            return false;
        }
        List potentials = target.get();
        if (potentials.size() < 2) {
            return false;
        }
        this.currentBreedTargets.clear();
        this.currentBreedTargets.addAll(potentials);
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_target", this.currentBreedTargets.size(), this.translate((Entity)this.currentBreedTargets.get(0))), false);
        return true;
    }

    private boolean breedTarget() {
        AnimalEntity animal = this.currentBreedTargets.get(this.currentBreedIndex);
        ItemStack breedStack = this.getHeldBreedItem(animal);
        if (breedStack.func_190926_b()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_wrong_item", new Object[0]), false);
            this.isFinished = true;
            return false;
        }
        if (this.interactTimer > 0) {
            if (this.interactTimer == 5) {
                this.construct.getHandWithCapability(ConstructCapability.CARRY).ifPresent(h -> this.construct.func_184609_a((Hand)h));
            }
            --this.interactTimer;
            return false;
        }
        animal.func_204700_e(600);
        breedStack.func_190918_g(1);
        this.interactTimer = this.getInteractTime(ConstructCapability.CARRY);
        return true;
    }

    private List<Item> getValidHeldBreedItems() {
        HashMap<Item, Integer> breedItems = new HashMap<Item, Integer>();
        for (ItemStack stack : this.getHeldItems()) {
            if (breedItems.containsKey(stack.func_77973_b())) {
                breedItems.put(stack.func_77973_b(), (Integer)breedItems.get(stack.func_77973_b()) + stack.func_190916_E());
                continue;
            }
            breedItems.put(stack.func_77973_b(), stack.func_190916_E());
        }
        return breedItems.entrySet().stream().filter(e -> (Integer)e.getValue() >= 1).map(e -> (Item)e.getKey()).collect(Collectors.toList());
    }

    private ItemStack getHeldBreedItem(AnimalEntity animal) {
        if (animal.func_70877_b(this.construct.func_184614_ca())) {
            return this.construct.func_184614_ca();
        }
        if (animal.func_70877_b(this.construct.func_184592_cb())) {
            return this.construct.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.moveEntityTarget = null;
        this.currentBreedTargets.clear();
        this.currentBreedIndex = 0;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.breedArea == null) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.breed_not_configured", new Object[0]), false);
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.breedArea.func_216364_b(), this.breedArea.func_216360_c(), this.breedArea.func_216362_d()), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.BREED;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructBreed) {
            this.breedArea = ((ConstructBreed)other).breedArea;
            this.currentBreedTargets.clear();
            this.currentBreedTargets.addAll(((ConstructBreed)other).currentBreedTargets);
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    protected CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        this.breedArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.breedArea = MathUtilities.createInclusiveBB(firstPos, secondPos);
                if (this.breedArea.func_216364_b() > 32.0 || this.breedArea.func_216360_c() > 32.0 || this.breedArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.breedArea != null;
    }
}

