/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.BlockUtils;
import com.ma.tools.math.MathUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.ToolType;

public class ConstructChop
extends ConstructCommand {
    private static final int MAX_SIZE = 32;
    private static final int MAX_BLOCKS_CHECKED_PER_TICK = 50;
    private static final int BREAK_TIME = 80;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CHOP_WOOD};
    private int interactTimer = this.getInteractTime(ConstructCapability.CHOP_WOOD);
    private boolean tooBig = false;
    private AxisAlignedBB plantArea = null;
    private BlockPos currentPlantTarget = null;
    private NonNullList<BlockPos> knownPlantTargets;
    private int lastPlantLocation = 0;
    private int breakProgress = 0;
    private int lastBreakProgressSync = 0;
    private int blockBreakLimit = 125;
    private int blockBreakCount = 0;
    private ArrayList<Long> checkedBlocks;
    private boolean searchingSurroundings = false;
    int x;
    int y;
    int z;

    public ConstructChop(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.knownPlantTargets = NonNullList.func_191196_a();
        this.checkedBlocks = new ArrayList();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.currentPlantTarget == null) {
            this.findBlockTarget();
            return;
        }
        this.moveBlockTarget = this.currentPlantTarget;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
                return;
            }
            if (this.construct.field_70170_p.func_195588_v(this.currentPlantTarget)) {
                BlockState state = this.construct.field_70170_p.func_180495_p(this.currentPlantTarget);
                if (this.isValidBlock(state, this.currentPlantTarget)) {
                    this.harvest();
                } else {
                    this.currentPlantTarget = null;
                }
            }
        }
    }

    private void harvest() {
        ++this.breakProgress;
        int breakProgressSync = (int)((float)this.breakProgress / 80.0f * 10.0f);
        if (this.breakProgress >= 80) {
            this.breakTreeRecursive(this.currentPlantTarget);
            this.knownPlantTargets.remove((Object)this.currentPlantTarget);
            ++this.lastPlantLocation;
            if (this.lastPlantLocation > this.knownPlantTargets.size()) {
                this.lastPlantLocation = 0;
            }
            this.breakProgress = 0;
            this.lastBreakProgressSync = 0;
            this.blockBreakCount = 0;
            this.checkedBlocks.clear();
            this.isFinished = true;
        } else {
            if (breakProgressSync != this.lastBreakProgressSync) {
                this.construct.field_70170_p.func_175715_c(this.construct.func_145782_y(), this.currentPlantTarget, breakProgressSync);
                this.lastBreakProgressSync = breakProgressSync;
            }
            if (this.breakProgress % 20 == 0) {
                this.construct.getHandWithCapability(ConstructCapability.CHOP_WOOD).ifPresent(h -> this.construct.func_184609_a((Hand)h));
            }
        }
    }

    private void breakTreeRecursive(BlockPos origin) {
        int radius = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = origin.func_177971_a((Vector3i)new BlockPos(x, y, z));
                    if (this.checkedBlocks.contains(pos.func_218275_a())) continue;
                    this.checkedBlocks.add(pos.func_218275_a());
                    BlockTypes block = this.isLogOrLeaf(this.construct.field_70170_p.func_180495_p(pos), pos);
                    if (block != BlockTypes.LOG) continue;
                    ++this.blockBreakCount;
                    BlockUtils.destroyBlock((LivingEntity)this.construct, this.construct.field_70170_p, pos, true, 99, ToolType.AXE);
                    if (this.blockBreakCount > this.blockBreakLimit) continue;
                    this.breakTreeRecursive(pos);
                }
            }
        }
    }

    private boolean isValidBlock(BlockState state, BlockPos pos) {
        BlockState below = this.construct.field_70170_p.func_180495_p(pos.func_177977_b());
        if (this.construct.field_70170_p.func_175623_d(pos.func_177977_b())) {
            return false;
        }
        return BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c()) && !BlockTags.field_200031_h.func_230235_a_((Object)below.func_177230_c());
    }

    private BlockTypes isLogOrLeaf(BlockState state, BlockPos pos) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c())) {
            return BlockTypes.LOG;
        }
        if (BlockTags.field_206952_E.func_230235_a_((Object)state.func_177230_c())) {
            return BlockTypes.LEAF;
        }
        return BlockTypes.INVALID;
    }

    private void findBlockTarget() {
        if (this.plantArea == null) {
            return;
        }
        if (!this.searchingSurroundings && this.knownPlantTargets.size() == 0) {
            this.setupRecheck();
        }
        if (this.searchingSurroundings) {
            this.searchSurroundings();
        } else {
            this.pickPlantLocation();
        }
    }

    private void setupRecheck() {
        this.searchingSurroundings = true;
        this.knownPlantTargets.clear();
        this.lastPlantLocation = 0;
        this.x = (int)this.plantArea.field_72340_a;
        this.y = (int)this.plantArea.field_72338_b;
        this.z = (int)this.plantArea.field_72339_c;
    }

    private void searchSurroundings() {
        int count = 0;
        while ((double)this.x <= this.plantArea.field_72336_d) {
            while ((double)this.y <= this.plantArea.field_72337_e) {
                while ((double)this.z <= this.plantArea.field_72334_f) {
                    BlockPos curSearch = new BlockPos(this.x, this.y, this.z);
                    if (this.construct.field_70170_p.func_195588_v(curSearch) && this.isValidBlock(this.construct.field_70170_p.func_180495_p(curSearch), curSearch)) {
                        this.knownPlantTargets.add((Object)curSearch);
                    }
                    if (++count >= 50) {
                        return;
                    }
                    ++this.z;
                }
                this.z = (int)this.plantArea.field_72339_c;
                ++this.y;
            }
            this.y = (int)this.plantArea.field_72338_b;
            ++this.x;
        }
        this.searchingSurroundings = false;
        if (this.knownPlantTargets.size() == 0) {
            this.isFinished = true;
            return;
        }
    }

    private void pickPlantLocation() {
        int count = 0;
        while (this.lastPlantLocation < this.knownPlantTargets.size()) {
            BlockPos curSearch = (BlockPos)this.knownPlantTargets.get(this.lastPlantLocation);
            if (this.construct.field_70170_p.func_195588_v(curSearch)) {
                if (this.isValidBlock(this.construct.field_70170_p.func_180495_p(curSearch), curSearch)) {
                    this.currentPlantTarget = curSearch;
                    return;
                }
                this.knownPlantTargets.remove(this.lastPlantLocation);
                --this.lastPlantLocation;
            }
            if (++count >= 50) {
                return;
            }
            ++this.lastPlantLocation;
        }
        this.lastPlantLocation = 0;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.plantArea == null) {
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.plantArea.func_216364_b(), this.plantArea.func_216360_c(), this.plantArea.func_216362_d()), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
        if (this.currentPlantTarget != null) {
            this.construct.field_70170_p.func_175715_c(this.construct.func_145782_y(), this.currentPlantTarget, -1);
        }
        this.lastBreakProgressSync = 0;
        this.breakProgress = 0;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        this.plantArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.plantArea = MathUtilities.createInclusiveBB(firstPos, secondPos);
                if (this.plantArea.func_216364_b() > 32.0 || this.plantArea.func_216360_c() > 32.0 || this.plantArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.CHOP;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
    }

    @Override
    public boolean isFullyConfigured() {
        return this.plantArea != null;
    }

    private static enum BlockTypes {
        LOG,
        LEAF,
        INVALID;

    }
}

