/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.blocks.tileentities.TileEntityLodestar;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;

public class ConstructCommandFollowLodestar
extends ConstructCommandTileEntityInteract<TileEntityLodestar> {
    private int taskIndex;

    public ConstructCommandFollowLodestar(EntityAnimatedConstruct construct) {
        super(construct, TileEntityLodestar.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        ConstructCommand sub = this.getSubCommand();
        if (sub != null && sub.func_75253_b()) {
            sub.func_75246_d();
        }
    }

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a() && ((TileEntityLodestar)this.getTileEntity()).getCommandCount() > 0 && !this.construct.field_70170_p.func_175640_z(this.blockPos)) {
            if (this.taskIndex >= ((TileEntityLodestar)this.getTileEntity()).getCommandCount()) {
                this.taskIndex = 0;
            }
            while (this.taskIndex < ((TileEntityLodestar)this.getTileEntity()).getCommandCount()) {
                ConstructCommand sub = this.getSubCommand();
                if (sub == null) {
                    if (this.advanceTask()) continue;
                    break;
                }
                if (sub.requiredCapabilities().length > 0 && !this.construct.getConstructData().areCapabilitiesEnabled(sub.requiredCapabilities())) {
                    String cap = Arrays.asList(sub.requiredCapabilities()).stream().map(c -> c.toString()).collect(Collectors.joining(", "));
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.capability_missing", cap));
                    if (this.advanceTask()) continue;
                    break;
                }
                if (!sub.isFullyConfigured() || !sub.func_75250_a() || sub.isFinished()) {
                    this.advanceTask();
                }
                return true;
            }
        }
        return false;
    }

    private boolean advanceTask() {
        ++this.taskIndex;
        if (this.taskIndex > this.construct.getIntelligence()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.confused", new Object[0]));
            this.taskIndex = 0;
            return false;
        }
        return true;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        if (this.getTileEntity() == null || ((TileEntityLodestar)this.getTileEntity()).getCommandCount() == 0) {
            return;
        }
        ConstructCommand sub = this.getSubCommand();
        if (sub != null) {
            sub.func_75249_e();
        }
    }

    @Override
    public boolean func_75253_b() {
        if (this.getTileEntity() == null || this.construct.field_70170_p.func_175640_z(this.blockPos)) {
            return false;
        }
        ConstructCommand sub = this.getSubCommand();
        if (sub != null) {
            return sub.func_75253_b();
        }
        return false;
    }

    @Nullable
    private ConstructCommand getSubCommand() {
        if (this.getTileEntity() != null && !this.construct.field_70170_p.func_175640_z(this.blockPos)) {
            if (this.taskIndex >= ((TileEntityLodestar)this.getTileEntity()).getCommandCount()) {
                this.taskIndex = 0;
                return null;
            }
            ConstructCommand cmd = ((TileEntityLodestar)this.getTileEntity()).getCommand(this.taskIndex);
            cmd.getDataFromInventory(((TileEntityLodestar)this.getTileEntity()).getCommandInventory(this.taskIndex));
            cmd.setConstruct(this.construct);
            if (cmd.isFinished()) {
                cmd.func_75251_c();
                this.advanceTask();
                return null;
            }
            return cmd;
        }
        return null;
    }

    @Override
    public void onTaskSet() {
        super.onTaskSet();
        this.taskIndex = 0;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.LODESTAR;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        super.readNBT(nbt);
        if (nbt.func_74764_b("index")) {
            this.taskIndex = nbt.func_74762_e("index");
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        nbt = super.writeInternal(nbt);
        nbt.func_74768_a("index", this.taskIndex);
        return nbt;
    }
}

