/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.attributes.AttributeInit;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.constructs.parts._base.ConstructCapability;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;

public class ConstructCommandFollowOwner
extends ConstructCommand {
    private int leashRange = 32;
    private int targetRate = 20;

    public ConstructCommandFollowOwner(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.construct.getOwner() != null;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.owner != null && this.owner.func_70089_S()) {
            if (this.construct.getConstructData().isAnyCapabilityEnabled(ConstructCapability.MELEE_ATTACK, ConstructCapability.RANGED_ATTACK) && this.construct.field_70170_p.func_82737_E() % (long)this.targetRate == 0L) {
                this.targetNearby();
            }
            double ownerDist = this.construct.func_195048_a(this.owner.func_213303_ch());
            this.checkLeashRange(ownerDist);
            if (this.construct.func_70638_az() == null) {
                this.doFollowOwner(ownerDist);
            } else {
                this.doAttackTarget();
            }
        }
    }

    private void checkLeashRange(double ownerDist) {
        if (ownerDist > (double)(this.leashRange * this.leashRange)) {
            if (this.construct.func_70638_az() != null) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.leashed", this.translate((Entity)this.construct.func_70638_az())));
            }
            this.construct.func_70624_b(null);
            this.pathCooldown = 0;
        }
    }

    private void doFollowOwner(double ownerDist) {
        if (ownerDist < 4.0) {
            this.construct.func_70661_as().func_75499_g();
            for (Hand hand : this.construct.getCarryingHands()) {
                ItemStack stack = this.construct.func_184586_b(hand);
                this.construct.func_199701_a_(stack);
                this.construct.func_184611_a(hand, ItemStack.field_190927_a);
            }
        } else {
            this.moveEntityTarget = this.owner;
            this.doMove();
        }
    }

    private void doAttackTarget() {
        if (!this.construct.func_70638_az().func_70089_S()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.victory", this.translate((Entity)this.construct.func_70638_az())));
            this.construct.func_70624_b(null);
            return;
        }
        this.doAttack();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.follow", new Object[0]), false);
    }

    private void targetNearby() {
        if (this.owner == null || !this.owner.func_70089_S() || this.construct.func_70638_az() != null && this.construct.func_70638_az().func_70089_S()) {
            return;
        }
        double targetRange = this.construct.func_110148_a((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).func_111126_e();
        List entities = this.construct.field_70170_p.func_217357_a(MobEntity.class, this.construct.func_174813_aQ().func_72314_b(targetRange, 2.0, targetRange)).stream().filter(e -> e.func_70089_S() && (e instanceof IMob || e.func_70638_az() == this.construct.getOwner() || e.func_70643_av() == this.construct.getOwner())).collect(Collectors.toList());
        if (entities.size() == 0) {
            return;
        }
        entities.sort(new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                Double o1Dist = o1.func_70068_e((Entity)ConstructCommandFollowOwner.this.owner);
                Double o2Dist = o2.func_70068_e((Entity)ConstructCommandFollowOwner.this.owner);
                return o1Dist.compareTo(o2Dist);
            }
        });
        this.construct.func_70624_b((LivingEntity)((MobEntity)entities.get(0)));
        this.pathCooldown = 0;
        this.moveEntityTarget = this.construct.func_70638_az();
        this.doMove();
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.attack", this.translate(this.construct.func_70638_az().func_200600_R().func_210760_d(), new Object[0])), false);
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.FOLLOW_DEFEND;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return new CompoundNBT();
    }

    @Override
    public void getDataFromInventory(Inventory config) {
    }

    @Override
    public boolean isFullyConfigured() {
        return true;
    }
}

