/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRuneMarking;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class ConstructMove
extends ConstructCommand {
    protected BlockPos blockPos;
    protected Direction side;

    public ConstructMove(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.moveBlockTarget = this.blockPos;
        if (this.doMove()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_success", new Object[0]));
            this.isFinished = true;
            this.isSuccess = true;
            return;
        }
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.MOVE;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructMove) {
            this.side = ((ConstructMove)other).side;
            this.blockPos = ((ConstructMove)other).blockPos;
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.func_74768_a("direction", this.side.func_176745_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("blockPos")) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("blockPos"));
        }
        if (nbt.func_74764_b("direction")) {
            this.side = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
        }
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.blockPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
            this.side = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(marker);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

