/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.MATags;
import com.ma.tools.math.MathUtilities;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class ConstructPlant
extends ConstructCommand {
    private static final ResourceLocation SEEDS = new ResourceLocation("forge:seeds");
    private static final ResourceLocation CROPS = new ResourceLocation("forge:crops");
    private static final int MAX_SIZE = 32;
    private static final int MAX_BLOCKS_CHECKED_PER_TICK = 50;
    private static final int RECHECK_TIME = 6000;
    private boolean tooBig = false;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = this.getInteractTime(ConstructCapability.CARRY);
    private AxisAlignedBB plantArea = null;
    private BlockPos currentPlantTarget = null;
    private NonNullList<BlockPos> knownPlantTargets;
    private int lastPlantLocation = 0;
    private boolean searchingSurroundings = false;
    private long lastSurroundingsCheck = 0L;
    int x;
    int y;
    int z;

    public ConstructPlant(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.knownPlantTargets = NonNullList.func_191196_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (!this.heldItemIsValid()) {
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_empty_hands", new Object[0]), false);
            }
        }
        if (this.currentPlantTarget == null) {
            this.findBlockTarget();
            return;
        }
        this.moveBlockTarget = this.currentPlantTarget;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
                return;
            }
            if (this.construct.field_70170_p.func_195588_v(this.currentPlantTarget)) {
                BlockState state = this.construct.field_70170_p.func_180495_p(this.currentPlantTarget);
                if (state.func_177230_c() instanceof FarmlandBlock && this.construct.field_70170_p.func_175623_d(this.currentPlantTarget.func_177984_a())) {
                    Hand[] carrying;
                    for (Hand hand : carrying = this.construct.getCarryingHands(i -> i.func_77973_b() instanceof BlockItem && ((BlockItem)i.func_77973_b()).func_179223_d() instanceof CropsBlock)) {
                        ItemStack stack = this.construct.func_184586_b(hand);
                        BlockState plant = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
                        if (plant == null) continue;
                        String translatedStack = this.translate(stack);
                        stack.func_190918_g(1);
                        this.construct.field_70170_p.func_175656_a(this.currentPlantTarget.func_177984_a(), plant);
                        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.planting", translatedStack, this.currentPlantTarget.func_177958_n(), this.currentPlantTarget.func_177956_o(), this.currentPlantTarget.func_177952_p()));
                        this.isFinished = true;
                        this.isSuccess = true;
                        this.currentPlantTarget = null;
                        this.construct.func_184609_a(hand);
                        return;
                    }
                } else {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_badstate", this.currentPlantTarget.func_177958_n(), this.currentPlantTarget.func_177956_o(), this.currentPlantTarget.func_177952_p(), this.translate(state)));
                    this.currentPlantTarget = null;
                    this.isFinished = true;
                }
            }
        }
    }

    private void findBlockTarget() {
        if (this.plantArea == null) {
            return;
        }
        if (this.construct.field_70170_p.func_82737_E() - this.lastSurroundingsCheck > 6000L) {
            this.setupRecheck();
        }
        if (this.searchingSurroundings) {
            this.searchSurroundings();
        } else {
            this.pickPlantLocation();
        }
    }

    private void setupRecheck() {
        this.searchingSurroundings = true;
        this.lastSurroundingsCheck = this.construct.field_70170_p.func_82737_E();
        this.knownPlantTargets.clear();
        this.lastPlantLocation = 0;
        this.x = (int)this.plantArea.field_72340_a;
        this.y = (int)this.plantArea.field_72338_b;
        this.z = (int)this.plantArea.field_72339_c;
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.soil_scan_starting", new Object[0]));
    }

    private boolean heldItemIsValid() {
        return this.construct.getCarryingHands(i -> MATags.isItemEqual(i, SEEDS) || MATags.isItemEqual(i, CROPS)).length != 0;
    }

    private void searchSurroundings() {
        int count = 0;
        while ((double)this.x < this.plantArea.field_72336_d) {
            while ((double)this.y < this.plantArea.field_72337_e) {
                while ((double)this.z < this.plantArea.field_72334_f) {
                    BlockPos curSearch = new BlockPos(this.x, this.y, this.z);
                    if (this.construct.field_70170_p.func_195588_v(curSearch) && this.construct.field_70170_p.func_180495_p(curSearch).func_177230_c() instanceof FarmlandBlock) {
                        this.knownPlantTargets.add((Object)curSearch);
                    }
                    if (++count >= 50) {
                        return;
                    }
                    ++this.z;
                }
                this.z = (int)this.plantArea.field_72339_c;
                ++this.y;
            }
            this.y = (int)this.plantArea.field_72338_b;
            ++this.x;
        }
        this.searchingSurroundings = false;
        if (this.knownPlantTargets.size() == 0) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_scan_no_results", new Object[0]));
            this.isFinished = true;
            return;
        }
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_scan_success", new Object[0]));
    }

    private void pickPlantLocation() {
        int count = 0;
        if (this.knownPlantTargets.size() == 0) {
            this.isFinished = true;
            return;
        }
        while (this.lastPlantLocation < this.knownPlantTargets.size()) {
            BlockPos curSearch = (BlockPos)this.knownPlantTargets.get(this.lastPlantLocation);
            if (this.construct.field_70170_p.func_195588_v(curSearch)) {
                if (this.construct.field_70170_p.func_180495_p(curSearch).func_177230_c() instanceof FarmlandBlock) {
                    if (this.construct.field_70170_p.func_175623_d(curSearch.func_177984_a())) {
                        this.currentPlantTarget = curSearch;
                        return;
                    }
                } else {
                    this.knownPlantTargets.remove(this.lastPlantLocation);
                    --this.lastPlantLocation;
                    if (this.lastPlantLocation < 0 || this.lastPlantLocation >= this.knownPlantTargets.size()) {
                        this.lastPlantLocation = 0;
                    }
                }
            }
            if (++count >= 50) {
                return;
            }
            ++this.lastPlantLocation;
        }
        this.lastPlantLocation = 0;
        this.isFinished = true;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.plantArea == null) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_not_configured", new Object[0]), false);
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.plantArea.func_216364_b(), this.plantArea.func_216360_c(), this.plantArea.func_216362_d()), false);
            return false;
        }
        if (!this.heldItemIsValid()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.plant_empty_hands", new Object[0]), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.interactTimer = this.getInteractTime(ConstructCapability.CARRY);
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        this.plantArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.plantArea = MathUtilities.createInclusiveBB(firstPos, secondPos);
                if (this.plantArea.func_216364_b() > 32.0 || this.plantArea.func_216360_c() > 32.0 || this.plantArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.PLANT;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
    }

    @Override
    public boolean isFullyConfigured() {
        return this.plantArea != null;
    }
}

