/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.api.sound.SFX;
import com.ma.blocks.tileentities.TileEntityRunescribingTable;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRunescribingRecipe;
import com.ma.recipes.runeforging.RunescribingRecipe;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class ConstructRunescribe
extends ConstructCommandTileEntityInteract<TileEntity> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.SMITH, ConstructCapability.CARRY};
    private ItemStack recipeItem;
    private int interactTimer = this.getInteractTime(ConstructCapability.SMITH);
    private RunescribingRecipe _cached_target_recipe;

    public ConstructRunescribe(EntityAnimatedConstruct construct) {
        super(construct, TileEntity.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.recipeItem = ItemStack.field_190927_a;
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.getTileEntity() instanceof TileEntityRunescribingTable && ((TileEntityRunescribingTable)this.getTileEntity()).func_70301_a(TileEntityRunescribingTable.SLOT_PATTERN).func_77973_b() == ItemInit.RUNE_PATTERN.get();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (!this.recipeItem.func_190926_b()) {
            RunescribingRecipe r = ((ItemRunescribingRecipe)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get()).getRecipe(this.recipeItem, this.construct.field_70170_p);
            if (r != null) {
                this._cached_target_recipe = r;
            }
        } else {
            this._cached_target_recipe = null;
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_recipe_not_found", new Object[0]));
            }
        }
        if (this._cached_target_recipe == null || this.getTileEntity() == null || !(this.getTileEntity() instanceof TileEntityRunescribingTable)) {
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_no_recipe", new Object[0]));
            }
            return;
        }
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                this.interactTimer = this.getInteractTime(ConstructCapability.SMITH);
                if (this.scribeNext()) {
                    this.isFinished = true;
                    this.construct.field_70714_bg.func_85156_a((Goal)this);
                }
            }
        }
    }

    private boolean scribeNext() {
        long target_v_mutex;
        TileEntityRunescribingTable te = (TileEntityRunescribingTable)this.getTileEntity();
        if (te.func_70301_a(TileEntityRunescribingTable.SLOT_PATTERN).func_190926_b()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_no_item", new Object[0]));
            return true;
        }
        if (te.func_70301_a(TileEntityRunescribingTable.SLOT_PATTERN).func_77973_b() != ItemInit.RUNE_PATTERN.get()) {
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_invalid_item", new Object[0]));
            }
            return true;
        }
        PlayerEntity player = this.getOrCreatePlayer();
        long current_h_mutex = te.getHMutex();
        long current_v_mutex = te.getVMutex();
        this.construct.getHandWithCapability(ConstructCapability.SMITH).ifPresent(h -> this.construct.func_184609_a((Hand)h));
        long target_h_mutex = this._cached_target_recipe.getHMutex();
        if (current_h_mutex != target_h_mutex) {
            for (int i = 0; i < 64; ++i) {
                if (!this.isBitSet(target_h_mutex, i) || this.isBitSet(current_h_mutex, i)) continue;
                this.construct.field_70170_p.func_184148_a(null, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), SFX.Gui.CHISEL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (te.writeMutexChanges(current_h_mutex |= 1L << i, current_v_mutex, player, -1)) {
                    this.isSuccess = true;
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_success", new Object[0]));
                    return true;
                }
                return false;
            }
        }
        if (current_v_mutex != (target_v_mutex = this._cached_target_recipe.getVMutex())) {
            for (int i = 0; i < 64; ++i) {
                if (!this.isBitSet(target_v_mutex, i) || this.isBitSet(current_v_mutex, i)) continue;
                this.construct.field_70170_p.func_184148_a(null, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), SFX.Gui.CHISEL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (te.writeMutexChanges(current_h_mutex, current_v_mutex |= 1L << i, player, -1)) {
                    this.isSuccess = true;
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_success", new Object[0]));
                    return true;
                }
                return false;
            }
        }
        te.writeMutexChanges(target_h_mutex, target_v_mutex, player, -1);
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runescribe_success", new Object[0]));
        this.isSuccess = true;
        return true;
    }

    private boolean isBitSet(long value, int bitIndex) {
        return (value & 1L << bitIndex) != 0L;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = this.getInteractTime(ConstructCapability.SMITH);
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.RUNESCRIBE;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        super.readNBT(nbt);
        if (nbt.func_74764_b("recipe")) {
            this.recipeItem = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("recipe"))));
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        CompoundNBT internalNBT = super.writeInternal(nbt);
        internalNBT.func_74778_a("recipe", this.recipeItem.func_77973_b().getRegistryName().toString());
        return internalNBT;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        super.getDataFromInventory(config);
        this.recipeItem = config.func_70301_a(1);
    }
}

