/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.math.MathUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.IForgeShearable;

public class ConstructShear
extends ConstructCommand {
    private static final int MAX_SIZE = 32;
    private static final String KEY_CHICKEN_SHEAR_TIME = "last_shear_time";
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.SHEAR};
    private int interactTimer = this.getInteractTime(ConstructCapability.SHEAR);
    private AxisAlignedBB shearArea = null;
    private List<AnimalEntity> currentShearTargets;
    private int currentShearIndex = 0;
    private boolean tooBig = false;
    private ItemStack shearsStack = new ItemStack((IItemProvider)Items.field_151097_aZ);

    public ConstructShear(EntityAnimatedConstruct construct) {
        super(construct);
        this.currentShearTargets = new ArrayList<AnimalEntity>();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.currentShearTargets.size() == 0 && !this.locateShearTarget()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_no_target", new Object[0]), false);
            this.isFinished = true;
            return;
        }
        this.moveEntityTarget = (Entity)this.currentShearTargets.get(this.currentShearIndex);
        if (this.doMove() && this.shearTarget()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_success", this.translate((Entity)this.currentShearTargets.get(this.currentShearIndex))), false);
            ++this.currentShearIndex;
            if (this.currentShearIndex >= this.currentShearTargets.size()) {
                this.isFinished = true;
                this.isSuccess = true;
                return;
            }
        }
    }

    private boolean locateShearTarget() {
        this.currentShearIndex = 0;
        this.currentShearTargets = this.construct.field_70170_p.func_175647_a(AnimalEntity.class, this.shearArea, e -> e.func_70089_S() && (e instanceof IForgeShearable && ((IForgeShearable)e).isShearable(this.shearsStack, this.construct.field_70170_p, e.func_233580_cy_()) || e instanceof ChickenEntity && this.canChickenBeSheared((ChickenEntity)e)));
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_target", this.currentShearTargets.size()), false);
        return this.currentShearTargets.size() > 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private boolean shearTarget() {
        void var2_5;
        if (this.interactTimer > 0) {
            --this.interactTimer;
            return false;
        }
        AnimalEntity animal = this.currentShearTargets.get(this.currentShearIndex);
        Object var2_2 = null;
        if (animal instanceof ChickenEntity) {
            ChickenEntity chicken = (ChickenEntity)animal;
            if (!this.canChickenBeSheared(chicken)) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_not_shearable", this.translate((Entity)animal)), false);
                return false;
            }
            this.setNextShearTime(chicken);
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.add(new ItemStack((IItemProvider)Items.field_151008_G, (int)(Math.random() * 3.0 + 1.0)));
        } else if (animal instanceof IForgeShearable) {
            if (!((IForgeShearable)animal).isShearable(this.shearsStack, this.construct.field_70170_p, animal.func_233580_cy_())) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_not_shearable", this.translate((Entity)animal)), false);
                return false;
            }
            List list = ((IForgeShearable)animal).onSheared(this.getOrCreatePlayer(), this.shearsStack, this.construct.field_70170_p, animal.func_233580_cy_(), 0);
        }
        if (var2_5 == null) {
            return false;
        }
        Random rand = new Random();
        var2_5.forEach(d -> {
            ItemEntity ent = this.construct.func_70099_a((ItemStack)d, 1.0f);
            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
        });
        this.construct.getHandWithCapability(ConstructCapability.SHEAR).ifPresent(h -> this.construct.func_184609_a((Hand)h));
        this.construct.field_70170_p.func_184148_a(null, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), SoundEvents.field_187763_eJ, SoundCategory.NEUTRAL, 1.0f, (float)((int)(0.9 + Math.random() * 0.2)));
        this.interactTimer = this.getInteractTime(ConstructCapability.SHEAR);
        return true;
    }

    private boolean canChickenBeSheared(ChickenEntity chicken) {
        return !chicken.getPersistentData().func_74764_b(KEY_CHICKEN_SHEAR_TIME) || this.construct.field_70170_p.func_82737_E() >= chicken.getPersistentData().func_74763_f(KEY_CHICKEN_SHEAR_TIME);
    }

    private void setNextShearTime(ChickenEntity chicken) {
        chicken.getPersistentData().func_74772_a(KEY_CHICKEN_SHEAR_TIME, this.construct.field_70170_p.func_82737_E() + 1200L + (long)((int)(Math.random() * 2400.0)));
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.moveEntityTarget = null;
        this.currentShearTargets.clear();
        this.currentShearIndex = 0;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.shearArea == null) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.shear_not_configured", new Object[0]), false);
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.shearArea.func_216364_b(), this.shearArea.func_216360_c(), this.shearArea.func_216362_d()), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.SHEAR;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructShear) {
            this.shearArea = ((ConstructShear)other).shearArea;
            this.currentShearTargets.clear();
            this.currentShearTargets.addAll(((ConstructShear)other).currentShearTargets);
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    protected CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        this.shearArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.shearArea = MathUtilities.createInclusiveBB(firstPos, secondPos);
                if (this.shearArea.func_216364_b() > 32.0 || this.shearArea.func_216360_c() > 32.0 || this.shearArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.shearArea != null;
    }
}

