/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ConstructTakeItem
extends ConstructCommandTileEntityInteract<TileEntity> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private ArrayList<Item> filter;
    private int interactTimer = 20;

    public ConstructTakeItem(EntityAnimatedConstruct construct) {
        super(construct, TileEntity.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.filter = new ArrayList();
    }

    public void setFilterAndContainer(BlockPos container, Direction side, List<Item> filter) {
        this.filter.clear();
        this.filter.addAll(filter);
        this.setTileEntity(container, side);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.interactTimer < 0) {
            --this.interactTimer;
            if (this.interactTimer <= -16) {
                this.isFinished = true;
                this.construct.field_70714_bg.func_85156_a((Goal)this);
            }
            return;
        }
        if (this.construct.getEmptyHands().length == 0) {
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.take_hands_full", this.translate((TileEntity)this.getTileEntity())));
            return;
        }
        if (this.getTileEntity() != null) {
            LazyOptional handler = this.getTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side);
            if (handler.isPresent()) {
                if (this.doMove()) {
                    if (this.interactTimer > 0) {
                        if (this.interactTimer == 5 && !InventoryUtilities.getFirstItemFromContainer(this.filter, this.construct.getCarrySize(), (IItemHandler)handler.resolve().get(), this.side, true).func_190926_b()) {
                            this.construct.getHandWithCapability(ConstructCapability.CARRY).ifPresent(h -> this.construct.func_184609_a((Hand)h));
                        }
                        --this.interactTimer;
                    } else if (this.interactTimer == 0) {
                        ItemStack stack = InventoryUtilities.getFirstItemFromContainer(this.filter, this.construct.getCarrySize(), (IItemHandler)handler.resolve().get(), this.side);
                        if (!stack.func_190926_b()) {
                            this.construct.func_184611_a(this.construct.getEmptyHands()[0], stack);
                            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.take_success", this.translate(stack), this.translate((TileEntity)this.getTileEntity())));
                        } else {
                            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.take_fail", this.translate((TileEntity)this.getTileEntity())));
                        }
                        this.interactTimer = -1;
                    }
                }
            } else {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.inv_missing_cap", this.translate((TileEntity)this.getTileEntity())));
            }
        } else {
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.te_missing", new Object[0]));
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.TAKE;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        super.copyFrom(other);
        if (other instanceof ConstructTakeItem) {
            this.filter.clear();
            this.filter.addAll(((ConstructTakeItem)other).filter);
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        super.readNBT(nbt);
        if (nbt.func_74764_b("count")) {
            this.filter = new ArrayList();
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = new ResourceLocation(nbt.func_74779_i("item" + i));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rLoc);
                if (item == null) continue;
                this.filter.add(item);
            }
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        nbt = super.writeInternal(nbt);
        nbt.func_74768_a("count", this.filter.size());
        for (int i = 0; i < this.filter.size(); ++i) {
            nbt.func_74778_a("item" + i, this.filter.get(i).getRegistryName().toString());
        }
        return nbt;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(10);
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        super.getDataFromInventory(config);
        this.filter.clear();
        for (int i = 1; i < 10; ++i) {
            ItemStack filterStack = config.func_70301_a(i);
            if (filterStack.func_190926_b()) continue;
            this.filter.add(filterStack.func_77973_b());
        }
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }
}

