/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai.base;

import com.ma.ManaAndArtifice;
import com.ma.entities.constructs.ai.ConstructActivate;
import com.ma.entities.constructs.ai.ConstructBreed;
import com.ma.entities.constructs.ai.ConstructButcher;
import com.ma.entities.constructs.ai.ConstructChop;
import com.ma.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.ma.entities.constructs.ai.ConstructCommandFollowOwner;
import com.ma.entities.constructs.ai.ConstructCommandReturnToTable;
import com.ma.entities.constructs.ai.ConstructCommandStay;
import com.ma.entities.constructs.ai.ConstructDropItem;
import com.ma.entities.constructs.ai.ConstructHarvest;
import com.ma.entities.constructs.ai.ConstructMove;
import com.ma.entities.constructs.ai.ConstructPatrol;
import com.ma.entities.constructs.ai.ConstructPlaceBlock;
import com.ma.entities.constructs.ai.ConstructPlaceItem;
import com.ma.entities.constructs.ai.ConstructPlant;
import com.ma.entities.constructs.ai.ConstructRuneforge;
import com.ma.entities.constructs.ai.ConstructRunescribe;
import com.ma.entities.constructs.ai.ConstructShear;
import com.ma.entities.constructs.ai.ConstructTakeItem;
import com.ma.entities.constructs.ai.ConstructWait;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.gui.containers.providers.constructs.NamedConstructActivate;
import com.ma.gui.containers.providers.constructs.NamedConstructBreed;
import com.ma.gui.containers.providers.constructs.NamedConstructButcher;
import com.ma.gui.containers.providers.constructs.NamedConstructChop;
import com.ma.gui.containers.providers.constructs.NamedConstructConfigurer;
import com.ma.gui.containers.providers.constructs.NamedConstructDropItem;
import com.ma.gui.containers.providers.constructs.NamedConstructHarvest;
import com.ma.gui.containers.providers.constructs.NamedConstructMove;
import com.ma.gui.containers.providers.constructs.NamedConstructPatrol;
import com.ma.gui.containers.providers.constructs.NamedConstructPlaceBlock;
import com.ma.gui.containers.providers.constructs.NamedConstructPlaceItem;
import com.ma.gui.containers.providers.constructs.NamedConstructPlant;
import com.ma.gui.containers.providers.constructs.NamedConstructRuneforge;
import com.ma.gui.containers.providers.constructs.NamedConstructRunescribe;
import com.ma.gui.containers.providers.constructs.NamedConstructShear;
import com.ma.gui.containers.providers.constructs.NamedConstructTakeItem;
import com.ma.gui.containers.providers.constructs.NamedConstructWait;
import javax.annotation.Nullable;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;

public enum ConstructActions {
    TAKE(0, 173, ConstructTakeItem.class, NamedConstructTakeItem.class),
    PLACE_ITEM(16, 173, ConstructPlaceItem.class, NamedConstructPlaceItem.class),
    RUNESCRIBE(16, 205, ConstructRunescribe.class, NamedConstructRunescribe.class),
    RUNEFORGE(0, 205, ConstructRuneforge.class, NamedConstructRuneforge.class),
    CHOP(16, 189, ConstructChop.class, NamedConstructChop.class),
    HARVEST(0, 189, ConstructHarvest.class, NamedConstructHarvest.class),
    PLANT(32, 205, ConstructPlant.class, NamedConstructPlant.class),
    ACTIVATE(17, 221, ConstructActivate.class, NamedConstructActivate.class),
    PATROL(32, 221, ConstructPatrol.class, NamedConstructPatrol.class),
    MOVE(64, 189, ConstructMove.class, NamedConstructMove.class),
    WAIT(48, 221, ConstructWait.class, NamedConstructWait.class),
    BUTCHER(0, 221, ConstructButcher.class, NamedConstructButcher.class),
    BREED(48, 189, ConstructBreed.class, NamedConstructBreed.class),
    SHEAR(64, 173, ConstructShear.class, NamedConstructShear.class),
    PLACE_BLOCK(48, 205, ConstructPlaceBlock.class, NamedConstructPlaceBlock.class),
    DROP_ITEM(48, 173, ConstructDropItem.class, NamedConstructDropItem.class),
    STAY(0, 0, ConstructCommandStay.class, null, false),
    MODIFY(0, 0, ConstructCommandReturnToTable.class, null, false),
    FOLLOW_DEFEND(0, 0, ConstructCommandFollowOwner.class, null, false),
    LODESTAR(0, 0, ConstructCommandFollowLodestar.class, null, false);

    private int tex_x;
    private int tex_y;
    private boolean lodestar_assignable = true;
    private Class<? extends ConstructCommand> ai_clazz;
    private Class<? extends NamedConstructConfigurer> container_clazz;

    private ConstructActions(int tex_x, int tex_y, Class<? extends ConstructCommand> aiClass, Class<? extends NamedConstructConfigurer> containerClass) {
        this(tex_x, tex_y, aiClass, containerClass, true);
    }

    private ConstructActions(int tex_x, int tex_y, Class<? extends ConstructCommand> aiClass, Class<? extends NamedConstructConfigurer> containerClass, boolean lodestar_assignable) {
        this.tex_x = tex_x;
        this.tex_y = tex_y;
        this.ai_clazz = aiClass;
        this.container_clazz = containerClass;
        this.lodestar_assignable = lodestar_assignable;
    }

    public int getTexX() {
        return this.tex_x;
    }

    public int getTexY() {
        return this.tex_y;
    }

    public Class<? extends ConstructCommand> getAIClass() {
        return this.ai_clazz;
    }

    public boolean isLodestarAssignable() {
        return this.lodestar_assignable;
    }

    @Nullable
    public INamedContainerProvider instantiateContainer(Inventory inventory) {
        if (this.container_clazz == null) {
            return null;
        }
        try {
            return this.container_clazz.getConstructor(Inventory.class).newInstance(inventory);
        }
        catch (Exception ex) {
            ManaAndArtifice.LOGGER.error("Failed to instantiate command container");
            ManaAndArtifice.LOGGER.error((Object)ex);
            return null;
        }
    }
}

