/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.animated;

import com.ma.api.affinity.Affinity;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.constructs.parts._base.ConstructMaterial;
import com.ma.items.constructs.parts._base.ConstructSlot;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.tools.math.MathUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class AnimatedConstructConstruction {
    private static final String KEY_NBT = "animated_construct_composition";
    private static final String KEY_AFFINITY = "animated_construct_affinity";
    private static final float WIND_SPEED_MODIFIER = 0.015f;
    private static final float WATER_BUOYANCY_MODIFIER = 1.0f;
    private HashMap<ConstructSlot, ItemConstructPart> partsList = new HashMap();
    private ArrayList<ConstructMaterial> composition = new ArrayList();
    private ArrayList<ConstructCapability> enabledCapabilities = new ArrayList();
    private HashMap<Affinity, Integer> affinityData = new HashMap();

    public boolean isComplete() {
        for (ConstructSlot slot : ConstructSlot.values()) {
            if (this.partsList.containsKey((Object)slot) && this.partsList.get((Object)slot) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (ConstructSlot slot : ConstructSlot.values()) {
            if (!this.partsList.containsKey((Object)slot) || this.partsList.get((Object)slot) == null) continue;
            return false;
        }
        return true;
    }

    private void calculateCompositionAndCapabilities() {
        this.composition.clear();
        this.enabledCapabilities.clear();
        for (ItemConstructPart part : this.partsList.values()) {
            if (!this.composition.contains((Object)part.getMaterial())) {
                this.composition.add(part.getMaterial());
            }
            for (ConstructCapability cap : part.getEnabledCapabilities()) {
                if (this.enabledCapabilities.contains((Object)cap)) continue;
                this.enabledCapabilities.add(cap);
            }
        }
    }

    public float calculateExplosionResistance() {
        float resistance = 0.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            resistance += part.getMaterial().getExplosionResistance();
        }
        return resistance;
    }

    public float calculateBuoyancy() {
        float buoyancy = 0.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            buoyancy += part.getMaterial().getBuoyancy();
        }
        return buoyancy += (float)this.getAffinityScore(Affinity.WATER) * 1.0f;
    }

    public int calculateMaxHealth() {
        int maxHealth = 0;
        for (ItemConstructPart part : this.partsList.values()) {
            maxHealth += part.getMaterial().getHealth();
        }
        return maxHealth;
    }

    public float calculateSpeed() {
        float speed = 0.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            speed += part.getMaterial().getSpeed() + part.getBonusSpeed();
        }
        return speed += (float)this.getAffinityScore(Affinity.WIND) * 0.015f;
    }

    public int calculateAttackRate() {
        int attackRate = 20;
        for (ItemConstructPart part : this.partsList.values()) {
            attackRate += part.getAttackSpeedModifier();
        }
        return attackRate;
    }

    public float calculateDamage() {
        float damage = 1.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            damage += part.getAttackDamage();
        }
        return damage;
    }

    public int calculateIntelligence() {
        int intelligence = 8;
        for (ItemConstructPart part : this.partsList.values()) {
            intelligence += part.getIntelligenceBonus();
        }
        return intelligence;
    }

    public int calculatePerception() {
        int perception = 8;
        for (ItemConstructPart part : this.partsList.values()) {
            perception += part.getPerceptionDistanceBonus();
        }
        return perception;
    }

    public float calculateKnockback() {
        int knockback = 0;
        for (ItemConstructPart part : this.partsList.values()) {
            knockback += part.getKnockbackBonus();
        }
        return knockback;
    }

    public float calculateKnockbackResistance() {
        int kbResist = 0;
        for (ItemConstructPart part : this.partsList.values()) {
            kbResist = (int)((float)kbResist + part.getMaterial().getKnockbackResistance());
        }
        return MathUtilities.clamp01(kbResist);
    }

    public float calculateMana() {
        float mana = 0.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            mana += (float)part.getManaCapacity();
        }
        return mana;
    }

    public int calculateArmor() {
        int armor = 0;
        for (ItemConstructPart part : this.partsList.values()) {
            armor += part.getArmor();
        }
        return armor;
    }

    public int calculateToughness() {
        int toughness = 0;
        for (ItemConstructPart part : this.partsList.values()) {
            toughness += part.getToughness();
        }
        return toughness;
    }

    public float calculateRangedDamage() {
        float damage = 0.0f;
        for (ItemConstructPart part : this.partsList.values()) {
            damage += part.getRangedAttackDamage();
        }
        return damage;
    }

    public ConstructCapability[] getEnabledCapabilities() {
        return this.enabledCapabilities.toArray(new ConstructCapability[0]);
    }

    public boolean isCapabilityEnabled(ConstructCapability cap) {
        return this.enabledCapabilities.contains((Object)cap);
    }

    public boolean areCapabilitiesEnabled(ConstructCapability ... caps) {
        for (ConstructCapability cap : caps) {
            if (this.enabledCapabilities.contains((Object)cap)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyCapabilityEnabled(ConstructCapability ... caps) {
        for (ConstructCapability cap : caps) {
            if (!this.enabledCapabilities.contains((Object)cap)) continue;
            return true;
        }
        return false;
    }

    public void resetParts() {
        this.partsList.clear();
        this.calculateCompositionAndCapabilities();
    }

    public ItemStack setPart(ItemConstructPart part) {
        return this.setPart(part, true);
    }

    public ItemStack setPart(ItemConstructPart part, boolean recalculate) {
        ItemStack output = ItemStack.field_190927_a;
        if (this.partsList.containsKey((Object)part.getSlot()) && this.partsList.get((Object)part.getSlot()) != null) {
            output = new ItemStack((IItemProvider)this.partsList.get((Object)part.getSlot()));
        }
        this.partsList.put(part.getSlot(), part);
        if (recalculate) {
            this.calculateCompositionAndCapabilities();
        }
        return output;
    }

    public Optional<ItemConstructPart> getPart(ConstructSlot slot) {
        if (this.partsList.containsKey((Object)slot)) {
            return Optional.of(this.partsList.get((Object)slot));
        }
        return Optional.empty();
    }

    public List<ConstructMaterial> getComposition() {
        return (List)this.composition.clone();
    }

    public List<ItemConstructPart> getPartsForMaterial(ConstructMaterial material) {
        return this.partsList.values().stream().filter(p -> p.getMaterial() == material).collect(Collectors.toList());
    }

    public int getAffinityScore(Affinity aff) {
        if (this.affinityData.containsKey((Object)aff)) {
            return this.affinityData.get((Object)aff.getShiftAffinity());
        }
        return 0;
    }

    public void setAffinityScore(Affinity aff, int value) {
        this.affinityData.put(aff, MathHelper.func_76125_a((int)value, (int)0, (int)8));
    }

    public Affinity getRandomContainedAffinity() {
        Affinity[] contained = this.affinityData.keySet().toArray(new Affinity[0]);
        return contained[(int)(Math.random() * (double)contained.length)];
    }

    public AnimatedConstructConstruction copy() {
        AnimatedConstructConstruction clone = new AnimatedConstructConstruction();
        for (ItemConstructPart part : this.partsList.values()) {
            clone.setPart(part, false);
        }
        clone.calculateCompositionAndCapabilities();
        return clone;
    }

    public void ReadNBT(CompoundNBT compound) {
        if (!compound.func_74764_b(KEY_NBT)) {
            return;
        }
        this.partsList.clear();
        CompoundNBT constructData = compound.func_74775_l(KEY_NBT);
        for (ConstructSlot slot : ConstructSlot.values()) {
            Item item;
            ResourceLocation rLoc;
            if (!constructData.func_74764_b(slot.toString()) || (rLoc = new ResourceLocation(constructData.func_74779_i(slot.toString()))).func_110623_a().isEmpty() || (item = (Item)ForgeRegistries.ITEMS.getValue(rLoc)) == null || !(item instanceof ItemConstructPart)) continue;
            this.partsList.put(((ItemConstructPart)item).getSlot(), (ItemConstructPart)item);
        }
        if (constructData.func_74764_b(KEY_AFFINITY)) {
            CompoundNBT affinity = constructData.func_74775_l(KEY_AFFINITY);
            for (Affinity aff : Affinity.values()) {
                if (!affinity.func_74764_b(aff.toString())) continue;
                this.affinityData.put(aff, affinity.func_74762_e(aff.toString()));
            }
        }
        this.calculateCompositionAndCapabilities();
    }

    public void WriteNBT(CompoundNBT compound) {
        CompoundNBT data = new CompoundNBT();
        if (this.partsList != null) {
            this.partsList.forEach((k, v) -> data.func_74778_a(k.toString(), v == null ? "" : v.getRegistryName().toString()));
        }
        CompoundNBT affinity = new CompoundNBT();
        if (this.affinityData != null) {
            for (Affinity aff : this.affinityData.keySet()) {
                affinity.func_74768_a(aff.toString(), this.affinityData.get((Object)aff).intValue());
            }
        }
        data.func_218657_a(KEY_AFFINITY, (INBT)affinity);
        compound.func_218657_a(KEY_NBT, (INBT)data);
    }

    @Nullable
    public ConstructMaterial getHighestMaterialForCapability(ConstructCapability capability) {
        List possibleParts = this.partsList.values().stream().filter(p -> this.arrayContains(p.getEnabledCapabilities(), capability)).collect(Collectors.toList());
        int ordinal = -1;
        for (ItemConstructPart p2 : possibleParts) {
            if (p2.getMaterial().ordinal() <= ordinal) continue;
            ordinal = p2.getMaterial().ordinal();
        }
        return ordinal >= 0 && ordinal < ConstructMaterial.values().length ? ConstructMaterial.values()[ordinal] : null;
    }

    private <T> boolean arrayContains(T[] arr, T search) {
        for (T elem : arr) {
            if (!elem.equals(search)) continue;
            return true;
        }
        return false;
    }

    public void copyFrom(AnimatedConstructConstruction construct) {
        for (ItemConstructPart part : construct.partsList.values()) {
            this.setPart(part, false);
        }
        this.calculateCompositionAndCapabilities();
    }
}

