/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.animated;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.attributes.AttributeInit;
import com.ma.entities.constructs.ai.ConstructActivate;
import com.ma.entities.constructs.ai.ConstructBreed;
import com.ma.entities.constructs.ai.ConstructButcher;
import com.ma.entities.constructs.ai.ConstructChop;
import com.ma.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.ma.entities.constructs.ai.ConstructCommandFollowOwner;
import com.ma.entities.constructs.ai.ConstructCommandReturnToTable;
import com.ma.entities.constructs.ai.ConstructCommandStay;
import com.ma.entities.constructs.ai.ConstructDropItem;
import com.ma.entities.constructs.ai.ConstructHarvest;
import com.ma.entities.constructs.ai.ConstructMove;
import com.ma.entities.constructs.ai.ConstructPatrol;
import com.ma.entities.constructs.ai.ConstructPlaceBlock;
import com.ma.entities.constructs.ai.ConstructPlaceItem;
import com.ma.entities.constructs.ai.ConstructPlant;
import com.ma.entities.constructs.ai.ConstructRuneforge;
import com.ma.entities.constructs.ai.ConstructRunescribe;
import com.ma.entities.constructs.ai.ConstructShear;
import com.ma.entities.constructs.ai.ConstructTakeItem;
import com.ma.entities.constructs.ai.ConstructWait;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.AnimatedConstructConstruction;
import com.ma.entities.constructs.animated.AnimatedConstructDiagnostics;
import com.ma.entities.sorcery.targeting.EntitySpellProjectile;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.constructs.parts._base.ConstructSlot;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.MATags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityAnimatedConstruct
extends GolemEntity
implements IAnimPacketSync<EntityAnimatedConstruct>,
IAnimatable,
AnimationController.ICustomInstructionListener {
    private static final String NBT_OWNER = "owner";
    private static final float PART_DROP_CHANCE = 0.5f;
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187203_m);
    AnimatedConstructConstruction constructCapabilities;
    AnimatedConstructDiagnostics constructDiagnostics;
    private boolean needsSync = true;
    private boolean requestingDiagnostics = false;
    private PlayerEntity cached_owner;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private final HashMap<ConstructActions, ConstructCommand> _registeredCommands;
    private ConstructCommand current;
    private static ArrayList<DamageSource> irresistibleDamageTypes = new ArrayList();
    private float max_mana = 0.0f;
    private float mana = 0.0f;
    private static final float MANA_PER_RANGED_ATTACK = 5.0f;
    private int chargeCounter = 0;
    private boolean ANIM_PACKET = false;
    private boolean isRangedAttacking = false;

    public EntityAnimatedConstruct(EntityType<? extends GolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.constructCapabilities = new AnimatedConstructConstruction();
        this.constructDiagnostics = new AnimatedConstructDiagnostics();
        this._registeredCommands = new HashMap();
        this._registeredCommands.put(ConstructActions.STAY, new ConstructCommandStay(this));
        this._registeredCommands.put(ConstructActions.FOLLOW_DEFEND, new ConstructCommandFollowOwner(this));
        this._registeredCommands.put(ConstructActions.MODIFY, new ConstructCommandReturnToTable(this));
        this._registeredCommands.put(ConstructActions.LODESTAR, new ConstructCommandFollowLodestar(this));
        this._registeredCommands.put(ConstructActions.TAKE, new ConstructTakeItem(this));
        this._registeredCommands.put(ConstructActions.PLACE_ITEM, new ConstructPlaceItem(this));
        this._registeredCommands.put(ConstructActions.RUNESCRIBE, new ConstructRunescribe(this));
        this._registeredCommands.put(ConstructActions.RUNEFORGE, new ConstructRuneforge(this));
        this._registeredCommands.put(ConstructActions.ACTIVATE, new ConstructActivate(this));
        this._registeredCommands.put(ConstructActions.HARVEST, new ConstructHarvest(this));
        this._registeredCommands.put(ConstructActions.PLANT, new ConstructPlant(this));
        this._registeredCommands.put(ConstructActions.CHOP, new ConstructChop(this));
        this._registeredCommands.put(ConstructActions.BUTCHER, new ConstructButcher(this));
        this._registeredCommands.put(ConstructActions.BREED, new ConstructBreed(this));
        this._registeredCommands.put(ConstructActions.PATROL, new ConstructPatrol(this));
        this._registeredCommands.put(ConstructActions.PLACE_BLOCK, new ConstructPlaceBlock(this));
        this._registeredCommands.put(ConstructActions.MOVE, new ConstructMove(this));
        this._registeredCommands.put(ConstructActions.WAIT, new ConstructWait(this));
        this._registeredCommands.put(ConstructActions.DROP_ITEM, new ConstructDropItem(this));
        this._registeredCommands.put(ConstructActions.SHEAR, new ConstructShear(this));
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityAnimatedConstruct) {
            return;
        }
        super.func_82167_n(entityIn);
    }

    public EntityAnimatedConstruct(World worldIn) {
        this((EntityType<? extends GolemEntity>)((EntityType)EntityInit.ANIMATED_CONSTRUCT.get()), worldIn);
    }

    public void setConstructParts(@Nonnull ItemConstructPart head, @Nonnull ItemConstructPart torso, @Nonnull ItemConstructPart left_arm, @Nonnull ItemConstructPart right_arm, @Nonnull ItemConstructPart legs) {
        this.constructCapabilities.setPart(head, false);
        this.constructCapabilities.setPart(torso, false);
        this.constructCapabilities.setPart(left_arm, false);
        this.constructCapabilities.setPart(right_arm, false);
        this.constructCapabilities.setPart(legs, true);
        this.recalculateAll();
    }

    public void setConstructParts(AnimatedConstructConstruction construction) {
        this.constructCapabilities = construction.copy();
        this.recalculateAll();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.constructDiagnostics.pushDiagnosticMessage(new TranslationTextComponent("mana-and-artifice.constructs.feedback.death").getString(), false);
    }

    @Nullable
    public PlayerEntity getOwner() {
        if (this.field_70180_af.func_187225_a(OWNER_UUID) == null || !((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent()) {
            return null;
        }
        if (this.cached_owner == null) {
            this.cached_owner = this.field_70170_p.func_217371_b((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get());
        }
        return this.cached_owner;
    }

    public void setOwner(UUID playerID) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(playerID));
    }

    public void setCurrentCommand(PlayerEntity player, ConstructCommand cmd) {
        ConstructCommand myCommand;
        if (((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent() && !((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get()).equals(player.func_110124_au())) {
            this.pushDiagnosticMessage(new TranslationTextComponent("mana-and-artifice.constructs.feedback.notowner", new Object[]{player.func_145748_c_().getString()}).getString());
            return;
        }
        if (this.current != null) {
            this.field_70714_bg.func_85156_a((Goal)this.current);
        }
        if ((myCommand = this._registeredCommands.get((Object)cmd.getType())) != cmd) {
            myCommand.copyFrom(cmd);
        }
        myCommand.onTaskSet();
        this.current = myCommand;
        this.field_70714_bg.func_75776_a(1, (Goal)myCommand);
    }

    public <T extends ConstructCommand> T getCommand(ConstructActions type) {
        return (T)((Object)this._registeredCommands.get((Object)type));
    }

    private void recalculateAll() {
        if (this.constructCapabilities != null) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.constructCapabilities.calculateMaxHealth());
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)this.constructCapabilities.calculateSpeed());
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)this.constructCapabilities.calculateDamage());
            this.func_110148_a(Attributes.field_233825_h_).func_111128_a((double)this.constructCapabilities.calculateAttackRate());
            this.func_110148_a(Attributes.field_233824_g_).func_111128_a((double)this.constructCapabilities.calculateKnockback());
            this.func_110148_a(Attributes.field_233820_c_).func_111128_a((double)this.constructCapabilities.calculateKnockbackResistance());
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a((double)this.constructCapabilities.calculateArmor());
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a((double)this.constructCapabilities.calculateToughness());
            this.func_110148_a((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).func_111128_a((double)this.constructCapabilities.calculatePerception());
            this.func_110148_a((Attribute)AttributeInit.INTELLIGENCE.get()).func_111128_a((double)this.constructCapabilities.calculateIntelligence());
            this.func_110148_a((Attribute)AttributeInit.RANGED_DAMAGE.get()).func_111128_a((double)this.constructCapabilities.calculateIntelligence());
            this.mana = this.constructCapabilities.calculateMana();
            this.field_70699_by.func_212239_d(this.func_204231_K());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        float resistance = 0.0f;
        if (!(source.func_151517_h() || source.func_76363_c() || irresistibleDamageTypes.contains(source))) {
            if (source.func_82725_o()) {
                resistance = 0.05f * (float)this.constructCapabilities.getAffinityScore(Affinity.ARCANE);
            } else if (!source.func_94541_c() && !source.func_76347_k()) {
                resistance = 0.05f * (float)this.constructCapabilities.getAffinityScore(Affinity.EARTH);
            }
        }
        if (source.func_94541_c()) {
            resistance += this.constructCapabilities.calculateExplosionResistance();
        }
        amount -= amount * resistance;
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.constructCapabilities.getAffinityScore(Affinity.FIRE) > 0) {
                entityIn.func_70015_d(this.constructCapabilities.getAffinityScore(Affinity.FIRE));
            }
            return true;
        }
        return false;
    }

    public boolean func_70648_aU() {
        if (this.getConstructData().isCapabilityEnabled(ConstructCapability.BREATHE_UNDERWATER)) {
            return true;
        }
        return super.func_70648_aU();
    }

    public int getCarrySize() {
        return Math.max(1, 2 * this.constructCapabilities.getAffinityScore(Affinity.ENDER));
    }

    public int getIntelligence() {
        return (int)this.func_110148_a((Attribute)AttributeInit.INTELLIGENCE.get()).func_111126_e();
    }

    public Hand[] getEmptyHands() {
        ArrayList emptyHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                emptyHands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
                emptyHands.add(Hand.OFF_HAND);
            }
        });
        return emptyHands.toArray(new Hand[0]);
    }

    public Hand[] getCarryingHands() {
        return this.getCarryingHands(null);
    }

    public Hand[] getCarryingHands(Predicate<ItemStack> filter) {
        ArrayList carryingHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            ItemStack left;
            if (p.getModelTypeMutex() == 1 && !(left = this.func_184586_b(Hand.MAIN_HAND)).func_190926_b() && (filter == null || filter.test(left))) {
                carryingHands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            ItemStack right;
            if (p.getModelTypeMutex() == 1 && !(right = this.func_184586_b(Hand.OFF_HAND)).func_190926_b() && (filter == null || filter.test(right))) {
                carryingHands.add(Hand.OFF_HAND);
            }
        });
        return carryingHands.toArray(new Hand[0]);
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        super.func_213345_d(damageSourceIn);
        for (ConstructSlot slot : ConstructSlot.values()) {
            this.constructCapabilities.getPart(slot).ifPresent(p -> {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack drops = ItemStack.field_190927_a;
                    if (Math.random() > 0.5) {
                        drops = new ItemStack((IItemProvider)p);
                    } else {
                        switch (p.getMaterial()) {
                            case DIAMOND: {
                                drops = new ItemStack((IItemProvider)Items.field_151045_i, 3);
                                break;
                            }
                            case GOLD: {
                                drops = new ItemStack((IItemProvider)Items.field_151043_k, 3);
                                break;
                            }
                            case IRON: {
                                drops = new ItemStack((IItemProvider)Items.field_151042_j, 3);
                                break;
                            }
                            case OBSIDIAN: {
                                drops = new ItemStack((IItemProvider)Items.field_221655_bP, 3);
                                break;
                            }
                            case STONE: {
                                drops = new ItemStack((IItemProvider)Items.field_221574_b, 3);
                                break;
                            }
                            case WOOD: {
                                List<Item> items = MATags.smartLookupItem(new ResourceLocation("logs"));
                                if (items == null || items.size() <= 0) break;
                                drops = new ItemStack((IItemProvider)items.get((int)(Math.random() * (double)items.size())), 3);
                                break;
                            }
                        }
                    }
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), drops);
                    if (damageSourceIn.func_94541_c()) {
                        itementity.func_213293_j(-0.5 + Math.random(), Math.random() * 0.5, -0.5 + Math.random());
                    }
                    itementity.func_174869_p();
                    this.field_70170_p.func_217376_c((Entity)itementity);
                }
            });
        }
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_82168_bl();
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.needsSync) {
            this.needsSync = false;
            if (!this.field_70170_p.field_72995_K) {
                ServerMessageDispatcher.sendEntityStateMessage(this);
            } else {
                ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.requestingDiagnostics && this.field_70173_aa % 20 == 0) {
            ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, true);
        }
    }

    public AnimatedConstructConstruction getConstructData() {
        return this.constructCapabilities;
    }

    public boolean func_204231_K() {
        return this.constructCapabilities.calculateBuoyancy() >= 1.0f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.constructCapabilities != null) {
            this.constructCapabilities.WriteNBT(compound);
        }
        compound.func_74778_a(NBT_OWNER, this.field_70180_af.func_187225_a(OWNER_UUID) != null && ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent() ? ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get()).toString() : "");
        if (this.current != null) {
            compound.func_218657_a("currentGoal", (INBT)this.current.writeNBT());
        }
        compound.func_74776_a("mana", this.mana);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.constructCapabilities.ReadNBT(compound);
        if (compound.func_74764_b(NBT_OWNER)) {
            try {
                this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(UUID.fromString(compound.func_74779_i(NBT_OWNER))));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Error loading construct owner UUID.  It is now unclaimed and can be claimed by any player.");
            }
        }
        this.recalculateAll();
        if (compound.func_74764_b("mana")) {
            this.mana = compound.func_74760_g("mana");
        }
        if (compound.func_74764_b("currentGoal")) {
            CompoundNBT goalData = compound.func_74775_l("currentGoal");
            ConstructActions action = ConstructCommand.getTypeFromNBT(goalData);
            this.current = this.getCommand(action);
            this.current.readNBT(goalData);
            this.field_70714_bg.func_75776_a(1, (Goal)this.current);
        }
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233825_h_, 20.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get(), 8.0).func_233815_a_((Attribute)AttributeInit.INTELLIGENCE.get(), 8.0).func_233815_a_((Attribute)AttributeInit.RANGED_DAMAGE.get(), 0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new ConstructSwimGoal());
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.ANIM_PACKET) {
            nbt.func_74774_a("anim", (byte)1);
            if (this.field_184622_au != null) {
                nbt.func_74774_a("hand", (byte)this.field_184622_au.ordinal());
            }
            nbt.func_74757_a("is_ranged_attacking", this.isRangedAttacking);
        } else if (!this.requestingDiagnostics) {
            this.constructCapabilities.WriteNBT(nbt);
        } else {
            nbt.func_218657_a("diag", (INBT)this.constructDiagnostics.writeToNBT());
        }
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        if (nbt.func_74764_b("anim")) {
            if (nbt.func_74764_b("hand")) {
                this.field_184622_au = Hand.values()[nbt.func_74771_c("hand")];
            }
            this.isRangedAttacking = nbt.func_74767_n("is_ranged_attacking");
        } else {
            this.constructCapabilities.ReadNBT(nbt);
            this.recalculateAll();
        }
        if (nbt.func_74764_b("diag")) {
            this.constructDiagnostics.readFromNBT(nbt.func_150295_c("diag", 8));
        }
    }

    public void pushDiagnosticMessage(String message, boolean allowDuplicates) {
        this.constructDiagnostics.pushDiagnosticMessage(message, allowDuplicates);
    }

    public void pushDiagnosticMessage(String message) {
        this.pushDiagnosticMessage(message, true);
    }

    public LinkedList<String> getDiagnostics() {
        return this.constructDiagnostics.getMessages();
    }

    public void setRequestingDiagnostics(boolean requesting) {
        this.requestingDiagnostics = requesting;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAddedToWorld()) {
            return PlayState.STOP;
        }
        if (this.isRangedAttacking) {
            if (this.field_184622_au == null || this.field_184622_au == Hand.MAIN_HAND) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.shoot_left", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.shoot_right", Boolean.valueOf(false)));
            }
        } else if (this.field_82175_bq) {
            if (this.field_184622_au == Hand.MAIN_HAND) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.swing_left", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.swing_right", Boolean.valueOf(false)));
            }
        } else if (!this.field_70122_E) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.airborne", Boolean.valueOf(true)));
        } else if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public <A extends IAnimatable> void executeInstruction(CustomInstructionKeyframeEvent<A> event) {
    }

    protected void func_82168_bl() {
        int i = 16;
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    public Optional<Hand> getHandWithCapability(ConstructCapability capability) {
        ArrayList hands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(Hand.OFF_HAND);
            }
        });
        if (hands.size() > 0) {
            Random r = new Random();
            Hand h = (Hand)hands.get(r.nextInt(hands.size()));
            return Optional.of(h);
        }
        return Optional.empty();
    }

    public boolean hasManaForRangedAttack() {
        return this.mana >= 5.0f;
    }

    public void consumeManaForRangedAttack() {
        this.mana -= 5.0f;
    }

    public void restoreMana(float amount) {
        this.mana += amount;
        if (this.mana > this.max_mana) {
            this.mana = this.max_mana;
        }
    }

    public float getMaxMana() {
        return this.max_mana;
    }

    public boolean performRangedAttack(LivingEntity attackTarget) {
        this.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
        ++this.chargeCounter;
        this.func_70661_as().func_75499_g();
        if (this.chargeCounter == 1) {
            this.isRangedAttacking = true;
            this.getHandWithCapability(ConstructCapability.RANGED_ATTACK).ifPresent(h -> {
                this.field_184622_au = h;
            });
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
        } else if (this.chargeCounter == 20) {
            Affinity aff = this.getConstructData().getRandomContainedAffinity();
            EntitySpellProjectile esp = new EntitySpellProjectile((LivingEntity)this, this.field_70170_p);
            esp.setForcedDamageAndAffinity(aff, (float)this.func_110148_a((Attribute)AttributeInit.RANGED_DAMAGE.get()).func_111126_e());
            esp.shoot((Entity)this, attackTarget.func_213303_ch().func_178788_d(this.func_213303_ch()), 1.0f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)esp);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Spell.Cast.ForAffinity(aff), SoundCategory.NEUTRAL, 0.25f, (float)(0.9 + Math.random() * 0.1));
            this.consumeManaForRangedAttack();
        } else if (this.chargeCounter == 40) {
            this.resetAttackState();
            return true;
        }
        return false;
    }

    public void resetAttackState() {
        this.chargeCounter = 0;
        this.isRangedAttacking = false;
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null && !this.field_70170_p.field_72995_K) {
            this.resetAttackState();
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    static {
        irresistibleDamageTypes.add(DamageSource.field_191291_g);
        irresistibleDamageTypes.add(DamageSource.field_76369_e);
        irresistibleDamageTypes.add(DamageSource.field_205132_u);
        irresistibleDamageTypes.add(DamageSource.field_76379_h);
        irresistibleDamageTypes.add(DamageSource.field_76368_d);
        irresistibleDamageTypes.add(DamageSource.field_76380_i);
        irresistibleDamageTypes.add(DamageSource.field_76366_f);
    }

    class ConstructSwimGoal
    extends Goal {
        public ConstructSwimGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            EntityAnimatedConstruct.this.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            if (!EntityAnimatedConstruct.this.func_204231_K()) {
                return false;
            }
            return EntityAnimatedConstruct.this.func_70090_H() && EntityAnimatedConstruct.this.func_233571_b_((ITag)FluidTags.field_206959_a) > EntityAnimatedConstruct.this.func_233579_cu_() || EntityAnimatedConstruct.this.func_180799_ab();
        }

        public void func_75246_d() {
            if (EntityAnimatedConstruct.this.func_70681_au().nextFloat() < 0.8f) {
                EntityAnimatedConstruct.this.func_70683_ar().func_75660_a();
            }
        }
    }
}

