/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.IAnimPacketSync;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.math.MathUtilities;
import java.util.EnumSet;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityDemonImp
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntityDemonImp>,
IFactionEnemy<EntityDemonImp> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final int LEAP_ATTACK_CD = 300;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private int leapAttackCooldown = 0;
    private boolean isAttacking = false;
    private boolean isLeapAttacking = false;
    private PlayerEntity raidTarget;

    public EntityDemonImp(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelDemonImp.walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelDemonImp.idle", Boolean.valueOf(true)));
            }
        } else if (this.isLeapAttacking) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelDemonImp.leap", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelDemonImp.attack", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.leapAttackCooldown;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), -0.5 + this.func_226277_ct_() + Math.random() * 0.5, this.func_226278_cu_() + Math.random() * (double)this.func_70047_e(), -0.5 + this.func_226281_cx_() + Math.random() * 0.5, this.func_213322_ci().field_72450_a, (double)0.1f, this.func_213322_ci().field_72449_c);
            }
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.DEMONS;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LerpLeap(4.0f, 16.0f, 5, 20, 25));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPredicate));
    }

    protected SoundEvent func_184639_G() {
        return SFX.Entity.Imp.IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SFX.Entity.Imp.DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SFX.Entity.Imp.ATTACK;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isAttacking) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.func_184185_a(SFX.Entity.Imp.ATTACK, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            return false;
        }
        if (source.func_76355_l() == "ma-frost" || source.func_76355_l() == "ma-lightning") {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.func_70638_az() == null) {
            return false;
        }
        double dist = this.func_70068_e((Entity)this.func_70638_az());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        if (this.isLeapAttacking) {
            f += 4.0f;
        }
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.func_233655_a_(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    private void func_233655_a_(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.6f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            if (this.isLeapAttacking) {
                this.leapAttackCooldown = 20;
                this.isLeapAttacking = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public <A extends IAnimatable> void executeInstruction(CustomInstructionKeyframeEvent<A> event) {
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        nbt.func_74757_a("leap_attacking", this.isLeapAttacking);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
        this.isLeapAttacking = nbt.func_74767_n("leap_attacking");
    }

    public class LerpLeap
    extends Goal {
        private float minDist;
        private float maxDist;
        private int lerpTicks;
        private int initialDelay;
        private int recoverTime;
        private int lerpCount = 0;
        private Vector3d start;
        private Vector3d end;
        private Vector3d control_1;
        private Vector3d control_2;

        public LerpLeap(float minDist, float maxDist, int initialDelay, int recoverTime, int lerpTime) {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.lerpTicks = lerpTime;
            this.initialDelay = initialDelay;
            this.recoverTime = recoverTime;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            if (EntityDemonImp.this.func_70638_az() == null || !EntityDemonImp.this.func_70089_S() || !EntityDemonImp.this.func_70638_az().func_70089_S() || EntityDemonImp.this.leapAttackCooldown > 0) {
                return false;
            }
            double dist = EntityDemonImp.this.func_70068_e((Entity)EntityDemonImp.this.func_70638_az());
            return dist >= (double)(this.minDist * this.minDist) && dist <= (double)(this.maxDist * this.maxDist);
        }

        public void func_75251_c() {
            this.lerpCount = 0;
            EntityDemonImp.this.func_189654_d(false);
            EntityDemonImp.this.isAttacking = false;
            EntityDemonImp.this.isLeapAttacking = false;
            ServerMessageDispatcher.sendEntityStateMessage(EntityDemonImp.this);
        }

        public boolean func_75253_b() {
            return EntityDemonImp.this.func_70638_az() != null && this.lerpCount < this.lerpTicks + this.initialDelay;
        }

        public void func_75249_e() {
            EntityDemonImp.this.func_189654_d(true);
            EntityDemonImp.this.func_70661_as().func_75499_g();
            EntityDemonImp.this.func_213317_d(Vector3d.field_186680_a);
            EntityDemonImp.this.isAttacking = true;
            EntityDemonImp.this.isLeapAttacking = true;
            ServerMessageDispatcher.sendEntityStateMessage(EntityDemonImp.this);
        }

        public void func_75246_d() {
            if (EntityDemonImp.this.func_70638_az() == null) {
                return;
            }
            float lerpPct = (float)(this.lerpCount++ - this.initialDelay) / (float)this.lerpTicks;
            if (this.lerpCount == this.initialDelay) {
                Vector3d direction = EntityDemonImp.this.func_70638_az().func_213303_ch().func_178788_d(EntityDemonImp.this.func_213303_ch()).func_72432_b();
                this.start = EntityDemonImp.this.func_213303_ch();
                this.end = EntityDemonImp.this.func_70638_az().func_213303_ch().func_178788_d(direction);
                Vector3d difference = this.end.func_178788_d(this.start);
                this.control_1 = this.start.func_178787_e(difference.func_186678_a(0.3)).func_72441_c(0.0, 1.0, 0.0);
                this.control_2 = this.start.func_178787_e(difference.func_186678_a(0.6)).func_72441_c(0.0, 1.0, 0.0);
                EntityDemonImp.this.func_184185_a(SFX.Entity.Imp.LEAP, 1.0f, (float)(0.9 + Math.random() * 0.2));
            }
            if (this.lerpCount > this.initialDelay && this.lerpCount - this.initialDelay <= this.lerpTicks) {
                Vector3d position = MathUtilities.bezierVector3d(this.start, this.end, this.control_1, this.control_2, lerpPct);
                EntityDemonImp.this.func_200602_a(EntityAnchorArgument.Type.FEET, EntityDemonImp.this.func_70638_az().func_213303_ch());
                EntityDemonImp.this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
                if (this.lerpCount - this.initialDelay == this.lerpTicks) {
                    EntityDemonImp.this.leapAttackCooldown = 300;
                    double dist = EntityDemonImp.this.func_70068_e((Entity)EntityDemonImp.this.func_70638_az());
                    if (dist < 16.0) {
                        EntityDemonImp.this.damageEntity((Entity)EntityDemonImp.this.func_70638_az());
                    }
                }
            }
        }
    }
}

