/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.entities.IAnimPacketSync;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityLanternWraith
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntityLanternWraith>,
IRangedAttackMob,
IFactionEnemy<EntityLanternWraith> {
    private static final String INSTRUCTION_BOLT = "bolt";
    private static final String INSTRUCTION_AFFECT = "affect";
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private boolean isAttacking = false;
    private PlayerEntity raidTarget;

    public EntityLanternWraith(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.move", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.idle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.attack", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, this.func_233637_b_(Attributes.field_233821_d_), 40, 80, 12.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPredicate));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            return false;
        }
        if (source.func_76355_l() == "ma-frost" || source.func_76355_l() == "ma-lightning") {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SFX.Entity.LanternWraith.HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SFX.Entity.LanternWraith.DEATH;
    }

    protected SoundEvent func_184639_G() {
        return SFX.Entity.LanternWraith.IDLE;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.DEMONS;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BOLT, 20, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219603_Y, SoundCategory.HOSTILE, 1.0f, (float)(0.9 + Math.random() * 0.2));
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public void spawnSoulFireBolt(Entity target) {
        if (!target.func_70089_S()) {
            return;
        }
        ServerMessageDispatcher.sendParticleSpawn(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.1f, this.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_(), 64.0f, (RegistryKey<World>)this.field_70170_p.func_234923_W_(), (BasicParticleType)ParticleInit.WRAITH_BOLT.get());
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Vector3d>(INSTRUCTION_AFFECT, 20, target.func_213303_ch(), this::tryAffectTarget));
    }

    public void tryAffectTarget(String identifier, Vector3d position) {
        LivingEntity entity = this.func_70638_az();
        if (entity == null) {
            return;
        }
        double dist = entity.func_195048_a(position);
        if (!entity.func_70089_S() || dist > 4.0) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            entity.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.consume(20.0f));
        }
        int magnitude = 0;
        int damage = 1;
        EffectInstance inst = entity.func_70660_b(Effects.field_76421_d);
        if (inst != null) {
            damage += inst.func_76458_c();
            if ((magnitude += inst.func_76458_c() + 1) > 2) {
                magnitude = 2;
            }
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, magnitude));
        entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "bolt": {
                    this.spawnSoulFireBolt((Entity)entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public <A extends IAnimatable> void executeInstruction(CustomInstructionKeyframeEvent<A> event) {
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
    }
}

