/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.sound.SFX;
import com.ma.entities.IAnimPacketSync;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityMushroomSoldier
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntityMushroomSoldier>,
IFactionEnemy<EntityMushroomSoldier> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_FLING = "fling";
    private static final int SKY_ATTACK_CD = 300;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private Entity attackEntity;
    private int skyAttackCooldown = 0;
    private boolean isAttacking = false;
    private boolean isSkyAttacking = false;
    private PlayerEntity raidTarget;

    public EntityMushroomSoldier(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72433_c() > (double)0.03f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.idle", Boolean.valueOf(true)));
            }
        } else if (this.isSkyAttacking) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.skyattack", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mushroom_soldier.attack", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219600_M;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219600_M;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232702_eA_;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.FEY_COURT;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.skyAttackCooldown;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPredicate));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isAttacking) {
            return true;
        }
        if (this.skyAttackCooldown <= 0) {
            this.isSkyAttacking = true;
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_FLING, 30, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        } else {
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        }
        this.isAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.attackEntity = entityIn;
        return true;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
            }
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.func_233655_a_(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    private void func_233655_a_(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "fling": {
                    entity.func_70024_g(0.0, 1.0, 0.0);
                    if (entity instanceof PlayerEntity) {
                        ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                    }
                    this.func_184185_a(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                    break;
                }
                case "damage": {
                    this.damageEntity(entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            if (this.isSkyAttacking) {
                this.skyAttackCooldown = 300;
                this.isSkyAttacking = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public <A extends IAnimatable> void executeInstruction(CustomInstructionKeyframeEvent<A> event) {
        event.instructions.forEach(s -> {
            if (s == INSTRUCTION_FLING && this.attackEntity == ManaAndArtifice.instance.proxy.getClientPlayer()) {
                this.attackEntity.func_70024_g(0.0, 1.0, 0.0);
            }
        });
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        nbt.func_74757_a("sky_attacking", this.isSkyAttacking);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
        this.isSkyAttacking = nbt.func_74767_n("sky_attacking");
    }
}

