/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.sound.SFX;
import com.ma.effects.EffectInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.faction.WitchHunterArrow;
import com.ma.entities.projectile.EntityWitchhunterTrickshot;
import com.ma.entities.sorcery.base.ChanneledSpellEntity;
import com.ma.entities.sorcery.targeting.EntitySpellProjectile;
import com.ma.entities.sorcery.targeting.EntitySpellSmite;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityWitchHunter
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntityWitchHunter>,
IRangedAttackMob,
IFactionEnemy<EntityWitchHunter> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_TRICKSHOT = "trickshot";
    private static final int TRICKSHOT_CD = 200;
    private static final int ROLL_CD = 60;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private boolean isAttacking = false;
    private boolean isTrickshotting = false;
    private boolean isRolling = false;
    private int trickshotCooldown = 0;
    private int rollCooldown = 0;
    private int nextTrickshotDuration = 200;
    private int nextTrickshotMagnitude = 200;
    private Effect nextTrickshotEffect = null;
    private boolean instantTransition = false;
    private PlayerEntity raidTarget;

    public EntityWitchHunter(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.trickshotCooldown;
        --this.rollCooldown;
    }

    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.ANCIENT_WIZARDS;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.instantTransition) {
            event.getController().transitionLengthTicks = 0.0;
            this.instantTransition = false;
        } else {
            event.getController().transitionLengthTicks = 5.0;
        }
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
            }
        } else if (this.isTrickshotting) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.throw", Boolean.valueOf(false)));
        } else if (this.isRolling) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.roll_short", Boolean.valueOf(false)).addAnimation("animation.model.idle", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.shoot", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new DodgeGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new TrickshotGoal((Effect)EffectInit.MANA_STUNT.get(), 200, 4, 8.0f, 16.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new TrickshotGoal(Effects.field_76421_d, 100, 3, 1.0f, 16.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, this.func_233637_b_(Attributes.field_233821_d_), this.func_233637_b_(Attributes.field_233821_d_) * 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new ShootGoal(this, this.func_233637_b_(Attributes.field_233821_d_), 20, 30, 12.0f));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPredicate));
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_DAMAGE, 10, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean spawnBolt(Entity target) {
        Vector3d direction = target.func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b();
        WitchHunterArrow arrow = new WitchHunterArrow(this.field_70170_p, this.func_226277_ct_() + direction.field_72450_a, this.func_226278_cu_() + (double)1.6f + direction.field_72448_b, this.func_226281_cx_() + direction.field_72449_c);
        arrow.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.field_70170_p.func_217376_c((Entity)arrow);
        this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public void spawnTrickshot(Effect effect, int duration, int magnitude) {
        if (this.func_70638_az() == null) {
            return;
        }
        EntityWitchhunterTrickshot trick = new EntityWitchhunterTrickshot(this.field_70170_p, this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0), this.func_70638_az().func_213303_ch().func_72441_c(0.0, 3.0, 0.0), effect, duration, magnitude);
        this.field_70170_p.func_217376_c((Entity)trick);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 20.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "damage": {
                    this.spawnBolt((Entity)entity);
                    break;
                }
                case "trickshot": {
                    this.spawnTrickshot(this.nextTrickshotEffect, this.nextTrickshotDuration, this.nextTrickshotMagnitude);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            if (this.isTrickshotting) {
                this.isTrickshotting = false;
                this.trickshotCooldown = 200;
            } else if (this.isRolling) {
                this.isRolling = false;
                this.rollCooldown = 60;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public <A extends IAnimatable> void executeInstruction(CustomInstructionKeyframeEvent<A> event) {
        if (event.instructions.contains("sound:woosh")) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Entity.Generic.WOOSH, SoundCategory.HOSTILE, 0.05f, (float)(0.9 + Math.random() * 0.2), false);
        }
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        nbt.func_74757_a(INSTRUCTION_TRICKSHOT, this.isTrickshotting);
        nbt.func_74757_a("roll", this.isRolling);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
        this.isTrickshotting = nbt.func_74767_n(INSTRUCTION_TRICKSHOT);
        boolean wasRolling = this.isRolling;
        this.isRolling = nbt.func_74767_n("roll");
        if (!this.isRolling && wasRolling) {
            this.instantTransition = true;
        }
    }

    public class DodgeGoal
    extends Goal {
        private Vector3d dodgeDirection;
        private Entity dodgeEntity;

        public DodgeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            if (EntityWitchHunter.this.rollCooldown > 0) {
                return false;
            }
            Vector3d rt_startVec = EntityWitchHunter.this.func_213303_ch();
            Vector3d thisFwd = Vector3d.func_189984_a((Vector2f)EntityWitchHunter.this.func_189653_aC());
            Vector3d rt_endVec = rt_startVec.func_178787_e(thisFwd.func_186678_a(10.0));
            List potentials = EntityWitchHunter.this.field_70170_p.func_72839_b((Entity)EntityWitchHunter.this, EntityWitchHunter.this.func_174813_aQ().func_186662_g(10.0)).stream().filter(e -> e instanceof EntitySpellProjectile || e instanceof EntitySpellSmite || e instanceof ChanneledSpellEntity).filter(e -> {
                AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_186662_g(2.0);
                Optional optional = axisalignedbb.func_216365_b(rt_startVec, rt_endVec);
                return optional.isPresent();
            }).collect(Collectors.toList());
            if (potentials.size() == 0) {
                return false;
            }
            potentials.sort(new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    Double d1 = o1.func_70068_e((Entity)EntityWitchHunter.this);
                    Double d2 = o2.func_70068_e((Entity)EntityWitchHunter.this);
                    return d1.compareTo(d2);
                }
            });
            this.dodgeEntity = (Entity)potentials.get(0);
            Vector3d fwd = this.dodgeEntity.func_213322_ci();
            this.dodgeDirection = new Vector3d(fwd.field_72450_a, 0.0, fwd.field_72449_c).func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
            float angle = (float)(Math.acos(this.dodgeDirection.func_72430_b(thisFwd.func_72432_b())) * 180.0 / Math.PI);
            if (angle > 90.0f) {
                this.dodgeDirection.func_186678_a(-1.0);
            }
            return true;
        }

        public void func_75249_e() {
            EntityWitchHunter.this.field_70699_by.func_75499_g();
            EntityWitchHunter.this.isRolling = true;
            EntityWitchHunter.this.isAttacking = true;
            EntityWitchHunter.this.func_70671_ap().func_75650_a(this.dodgeDirection.field_72450_a, this.dodgeDirection.field_72448_b, this.dodgeDirection.field_72449_c, 30.0f, 30.0f);
            EntityWitchHunter.this.func_213317_d(this.dodgeDirection);
            DelayedEventQueue.pushEvent(EntityWitchHunter.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 80, "", (x$0, x$1) -> EntityWitchHunter.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityWitchHunter.this);
        }

        public void func_75246_d() {
            EntityWitchHunter.this.func_70671_ap().func_75650_a(this.dodgeDirection.field_72450_a, this.dodgeDirection.field_72448_b, this.dodgeDirection.field_72449_c, 30.0f, 30.0f);
        }

        public boolean func_75253_b() {
            return EntityWitchHunter.this.isRolling;
        }

        protected EntityRayTraceResult rayTraceEntity(Vector3d startVec, Vector3d endVec, float size, Entity searchEntity) {
            return ProjectileHelper.func_221269_a((World)EntityWitchHunter.this.field_70170_p, (Entity)EntityWitchHunter.this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)EntityWitchHunter.this.func_174813_aQ().func_186662_g((double)size), entity -> searchEntity == entity);
        }
    }

    public class ShootGoal
    extends Goal {
        private int rangedAttackTime = -1;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public ShootGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public ShootGoal(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = EntityWitchHunter.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S();
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !EntityWitchHunter.this.func_70661_as().func_75500_f();
        }

        public void func_75251_c() {
            this.rangedAttackTime = -1;
        }

        public void func_75246_d() {
            LivingEntity e = EntityWitchHunter.this.func_70638_az();
            if (e == null) {
                return;
            }
            double distance = EntityWitchHunter.this.func_70092_e(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
            boolean canSeeTarget = EntityWitchHunter.this.func_70635_at().func_75522_a((Entity)e);
            if (distance <= (double)this.maxAttackDistance && canSeeTarget) {
                EntityWitchHunter.this.func_70661_as().func_75499_g();
            } else {
                EntityWitchHunter.this.func_70661_as().func_75497_a((Entity)e, EntityWitchHunter.this.func_233637_b_(Attributes.field_233821_d_));
            }
            EntityWitchHunter.this.func_70671_ap().func_75651_a((Entity)e, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!canSeeTarget) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                EntityWitchHunter.this.func_82196_d(e, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }

    public class TrickshotGoal
    extends Goal {
        private Effect potionEffect;
        private int potionDuration;
        private int potionMagnitude;
        private float minDistance;
        private float maxDistance;
        private boolean startedAction;

        public TrickshotGoal(Effect effect, int duration, int magnitude, float minDistance, float maxDistance) {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.potionEffect = effect;
            this.potionDuration = duration;
            this.potionMagnitude = magnitude;
            this.minDistance = minDistance * minDistance;
            this.maxDistance = maxDistance * maxDistance;
            this.startedAction = false;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            return EntityWitchHunter.this.trickshotCooldown <= 0 && !EntityWitchHunter.this.isTrickshotting && !EntityWitchHunter.this.isRolling && EntityWitchHunter.this.func_70638_az() != null && !EntityWitchHunter.this.func_70638_az().func_70644_a(this.potionEffect) && EntityWitchHunter.this.func_70068_e((Entity)EntityWitchHunter.this.func_70638_az()) >= (double)this.minDistance;
        }

        public void func_75249_e() {
            this.startedAction = false;
        }

        public void func_75246_d() {
            LivingEntity at = EntityWitchHunter.this.func_70638_az();
            if (at == null) {
                return;
            }
            if (!EntityWitchHunter.this.isTrickshotting) {
                if (this.tryMove(at)) {
                    this.startAction();
                }
            } else {
                EntityWitchHunter.this.func_70671_ap().func_75651_a((Entity)at, 30.0f, 30.0f);
            }
        }

        private void startAction() {
            EntityWitchHunter.this.func_70661_as().func_75499_g();
            EntityWitchHunter.this.isTrickshotting = true;
            EntityWitchHunter.this.isAttacking = true;
            EntityWitchHunter.this.nextTrickshotDuration = this.potionDuration;
            EntityWitchHunter.this.nextTrickshotMagnitude = this.potionMagnitude;
            EntityWitchHunter.this.nextTrickshotEffect = this.potionEffect;
            DelayedEventQueue.pushEvent(EntityWitchHunter.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityWitchHunter.INSTRUCTION_TRICKSHOT, 50, (LivingEntity)EntityWitchHunter.this, (x$0, x$1) -> EntityWitchHunter.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityWitchHunter.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 100, "", (x$0, x$1) -> EntityWitchHunter.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityWitchHunter.this);
            this.startedAction = true;
        }

        private boolean tryMove(LivingEntity at) {
            double distance = EntityWitchHunter.this.func_70092_e(at.func_226277_ct_(), at.func_226278_cu_(), at.func_226281_cx_());
            boolean canSeeTarget = EntityWitchHunter.this.func_70635_at().func_75522_a((Entity)at);
            if (distance <= (double)this.maxDistance && canSeeTarget) {
                EntityWitchHunter.this.func_70661_as().func_75499_g();
                return true;
            }
            EntityWitchHunter.this.func_70661_as().func_75497_a((Entity)at, EntityWitchHunter.this.func_233637_b_(Attributes.field_233821_d_));
            EntityWitchHunter.this.func_70671_ap().func_75651_a((Entity)at, 30.0f, 30.0f);
            return false;
        }

        public boolean func_75253_b() {
            return !this.startedAction || EntityWitchHunter.this.isTrickshotting || !EntityWitchHunter.this.func_70661_as().func_75500_f();
        }
    }
}

