/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.FactionRaidRegistry;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FactionRaidEntity
extends Entity {
    private static final DataParameter<Integer> FACTION = EntityDataManager.func_187226_a(FactionRaidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private PlayerEntity player;
    private UUID playerUUID;
    private int strength;

    public FactionRaidEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FactionRaidEntity(World world, PlayerEntity target, int strength) {
        super((EntityType)EntityInit.FACTION_RAID_ENTITY.get(), world);
        this.player = target;
        this.strength = strength;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !this.spawnRaidEntity()) {
            this.remove(false);
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getFaction() == Faction.DEMONS) {
                int i;
                for (i = 0; i < 15; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)-0.05f + Math.random() * (double)0.1f, (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() - 0.5 + Math.random() * 1.0, this.func_226278_cu_(), this.func_226281_cx_() - 0.5 + Math.random() * 1.0, 0.0, (double)0.05f, 0.0);
                for (i = 0; i < 5; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218424_l, this.func_226277_ct_() - 1.5 + Math.random() * 3.0, this.func_226278_cu_(), this.func_226281_cx_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
                }
            }
        } else if (this.field_70173_aa == 20) {
            switch (this.getFaction()) {
                case ANCIENT_WIZARDS: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_COUNCIL, 1.0f, 1.0f);
                    break;
                }
                case DEMONS: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_DEMONS, 1.0f, 1.0f);
                    break;
                }
                case FEY_COURT: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_FEY, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    private PlayerEntity getPlayer() {
        if (this.player == null && this.playerUUID != null) {
            this.player = this.field_70170_p.func_217371_b(this.playerUUID);
        }
        return this.player;
    }

    private boolean spawnRaidEntity() {
        if (this.getPlayer() == null) {
            return false;
        }
        EntityType<? extends IFactionEnemy<? extends LivingEntity>> soldier = FactionRaidRegistry.getSoldier(this.getFaction(), this.strength);
        if (soldier == null) {
            return false;
        }
        IFactionEnemy entity = (IFactionEnemy)soldier.func_200721_a(this.field_70170_p);
        entity.setRaidTarget(this.getPlayer());
        ((LivingEntity)entity).func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76429_m, 40, 3));
        this.field_70170_p.func_217376_c((Entity)entity);
        this.strength -= FactionRaidRegistry.getStrengthRating(this.getFaction(), soldier);
        return this.strength > 0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FACTION, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("strength")) {
            this.strength = compound.func_74762_e("strength");
        }
        if (compound.func_74764_b("faction")) {
            this.field_70180_af.func_187227_b(FACTION, (Object)compound.func_74762_e("faction"));
        }
        if (compound.func_74764_b("target")) {
            try {
                this.playerUUID = UUID.fromString(compound.func_74779_i("target"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load player UUID when loading faction raid.  Skipping and despawning the raid.");
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("strength", this.strength);
        compound.func_74768_a("faction", ((Integer)this.field_70180_af.func_187225_a(FACTION)).intValue());
        if (this.player != null) {
            compound.func_74778_a("target", this.player.func_110124_au().toString());
        }
    }

    public Faction getFaction() {
        return Faction.values()[(Integer)this.field_70180_af.func_187225_a(FACTION)];
    }

    public void setFaction(Faction faction) {
        this.field_70180_af.func_187227_b(FACTION, (Object)faction.ordinal());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

