/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.manaweaving;

import com.ma.api.capabilities.ICantrip;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.blocks.BlockInit;
import com.ma.blocks.tileentities.TileEntityManaweavingAltar;
import com.ma.blocks.tileentities.TileEntityPedestal;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.events.EventDispatcher;
import com.ma.items.ItemInit;
import com.ma.items.ItemManaweaveBottle;
import com.ma.network.ServerMessageDispatcher;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityManaweave
extends LivingEntity {
    private static final int MAX_AGE = 200;
    private static final DataParameter<CompoundNBT> PATTERNS = EntityDataManager.func_187226_a(EntityManaweave.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(EntityManaweave.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final String NBT_ENTITY_AGE = "entity_age";
    private static final String NBT_PATTERN = "patterns";
    private static final String NBT_CASTER_UUID = "caster_uuid";
    int age = 0;
    boolean isMerging = false;
    private ArrayList<ManaweavingPattern> cachedPatterns;

    public EntityManaweave(EntityType<? extends LivingEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityManaweave(World world) {
        this((EntityType<? extends LivingEntity>)((EntityType)EntityInit.MANAWEAVE_ENTITY.get()), world);
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public void func_70071_h_() {
        if (!(this.getPatterns() != null && this.getPatterns().size() != 0 || this.field_70170_p.field_72995_K)) {
            this.remove(false);
        }
        if (this.age == 0 && !this.field_70170_p.field_72995_K && !this.notifyManaweaveAltars()) {
            this.mergeWithNearby();
        }
        ++this.age;
        if (this.age >= 200 && !this.field_70170_p.field_72995_K) {
            this.remove(false);
        }
    }

    public boolean isMerging() {
        return this.isMerging;
    }

    public void setMerging(boolean merging) {
        this.isMerging = merging;
    }

    public float getManaReturn(PlayerEntity player) {
        return this.getPatterns().size() * 25;
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setPattern(ResourceLocation pattern) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("count", 0);
        nbt.func_74778_a("index_0", pattern.toString());
        this.field_70180_af.func_187227_b(PATTERNS, (Object)nbt);
        this.cachedPatterns = null;
    }

    public void addPattern(ResourceLocation pattern) {
        CompoundNBT nbt = ((CompoundNBT)this.field_70180_af.func_187225_a(PATTERNS)).func_74737_b();
        int count = nbt.func_74762_e("count") + 1;
        nbt.func_74768_a("count", count);
        nbt.func_74778_a("index_" + count, pattern.toString());
        this.field_70180_af.func_187227_b(PATTERNS, (Object)nbt);
        this.cachedPatterns = null;
    }

    @Nullable
    public PlayerEntity getCaster() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(CASTER_UUID);
        if (uuid.isPresent()) {
            return this.field_70170_p.func_217371_b((UUID)uuid.get());
        }
        return null;
    }

    public void setCaster(PlayerEntity player) {
        if (player != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(player.func_110124_au()));
        }
    }

    public void mergeWith(EntityManaweave other) {
        for (ManaweavingPattern p : other.getPatterns()) {
            this.addPattern(p.func_199560_c());
        }
        other.func_70106_y();
    }

    private void mergeWithNearby() {
        if (this.getCaster() == null) {
            return;
        }
        List mws = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(2.0), e -> e instanceof EntityManaweave && ((EntityManaweave)((Object)e)).getCaster() == this.getCaster());
        for (Entity e2 : mws) {
            this.mergeWith((EntityManaweave)e2);
        }
        if (this.getPatterns().size() > 1) {
            this.checkMergeRecipe();
        }
    }

    private void checkMergeRecipe() {
        PlayerEntity caster = this.getCaster();
        if (caster == null) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return;
        }
        if (caster.func_70068_e((Entity)this) > 25.0) {
            return;
        }
        ICantrip cantrip = magic.getCantripData().matchAndCastCantrip(caster, this.getPatterns().stream().map(r -> r).collect(Collectors.toList()));
        if (cantrip != null) {
            ServerMessageDispatcher.sendCantripTimerMessage(cantrip.getId(), cantrip.getDelay(), cantrip.getChevrons(), (ServerPlayerEntity)caster);
            EventDispatcher.DispatchCantripCast(cantrip, caster);
            if (cantrip.getSound() != null) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), cantrip.getSound(), SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            this.func_70106_y();
        }
    }

    @Nullable
    public ArrayList<ManaweavingPattern> getPatterns() {
        CompoundNBT nbt;
        if (this.cachedPatterns == null && (nbt = (CompoundNBT)this.field_70180_af.func_187225_a(PATTERNS)).func_74764_b("count")) {
            this.cachedPatterns = new ArrayList();
            int count = nbt.func_74762_e("count");
            for (int i = 0; i <= count; ++i) {
                String rLoc;
                ManaweavingPattern mwp;
                String key = "index_" + i;
                if (!nbt.func_74764_b(key) || (mwp = ManaweavingPatternHelper.GetManaweavingRecipe(this.field_70170_p, new ResourceLocation(rLoc = nbt.func_74779_i(key)))) == null) continue;
                this.cachedPatterns.add(mwp);
            }
        }
        return this.cachedPatterns;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151069_bo && this.getPatterns().size() == 1) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack captureStack = new ItemStack((IItemProvider)ItemInit.MANAWEAVE_BOTTLE.get());
                ItemManaweaveBottle.setPattern(this.getPatterns().get(0), captureStack);
                player.func_184586_b(hand).func_190918_g(1);
                if (!player.func_191521_c(captureStack)) {
                    player.func_199701_a_(captureStack);
                }
                this.remove(false);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PATTERNS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.of(UUID.randomUUID()));
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b(NBT_ENTITY_AGE)) {
            this.age = compound.func_74762_e(NBT_ENTITY_AGE);
        }
        if (compound.func_74764_b(NBT_PATTERN)) {
            this.field_70180_af.func_187227_b(PATTERNS, (Object)((CompoundNBT)compound.func_74781_a(NBT_PATTERN)));
        }
        if (compound.func_74764_b(NBT_CASTER_UUID)) {
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(UUID.fromString(compound.func_74779_i(NBT_CASTER_UUID))));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_ENTITY_AGE, this.age);
        compound.func_218657_a(NBT_PATTERN, (INBT)this.field_70180_af.func_187225_a(PATTERNS));
        compound.func_74778_a(NBT_CASTER_UUID, ((UUID)((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).get()).toString());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getAge() {
        return this.age;
    }

    private boolean notifyManaweaveAltars() {
        BlockPos test;
        int k;
        int j;
        int i;
        ArrayList<ManaweavingPattern> p = this.getPatterns();
        if (p == null || p.size() != 1) {
            return false;
        }
        PlayerEntity player = this.getCaster();
        if (player == null) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return false;
        }
        BlockPos me = this.func_233580_cy_();
        int radius = 3;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                for (k = -radius; k <= radius; ++k) {
                    TileEntityManaweavingAltar te;
                    test = me.func_177982_a(i, j, k);
                    if (this.field_70170_p.func_180495_p(test).func_177230_c() != ((Block)BlockInit.MANAWEAVING_ALTAR.get()).getBlock()) continue;
                    this.func_70107_b((float)test.func_177958_n() + 0.5f, (float)test.func_177956_o() + 1.5f, (float)test.func_177952_p() + 0.5f);
                    if (this.field_70170_p.field_72995_K || (te = (TileEntityManaweavingAltar)this.field_70170_p.func_175625_s(test)) == null || te.getAddedPatterns().size() >= 6) continue;
                    te.pushPattern(p.get(0), player);
                    this.remove(false);
                    return true;
                }
            }
        }
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                for (k = -radius; k <= radius; ++k) {
                    TileEntityPedestal te;
                    test = me.func_177982_a(i, j, k);
                    BlockState state = this.field_70170_p.func_180495_p(test);
                    if (state.func_177230_c() != ((Block)BlockInit.PEDESTAL.get()).getBlock()) continue;
                    this.func_70107_b((float)test.func_177958_n() + 0.5f, (float)test.func_177956_o() + 1.5f, (float)test.func_177952_p() + 0.5f);
                    if (this.field_70170_p.field_72995_K || (te = (TileEntityPedestal)this.field_70170_p.func_175625_s(test)) == null || te.func_70301_a(0).func_77973_b() != Items.field_151069_bo) continue;
                    ItemStack bottle = new ItemStack((IItemProvider)ItemInit.MANAWEAVE_BOTTLE.get());
                    ItemManaweaveBottle.setPattern(p.get(0), bottle);
                    te.func_70299_a(0, bottle);
                    this.field_70170_p.func_184138_a(test, state, state, 3);
                    this.remove(false);
                    return true;
                }
            }
        }
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == PATTERNS) {
            this.cachedPatterns = null;
        }
        super.func_184206_a(key);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }
}

