/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.manaweaving;

import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.items.ItemInit;
import com.ma.items.ItemManaweaveBottle;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityThrownManaweaveBottle
extends ProjectileItemEntity {
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::func_230270_dK_;

    public EntityThrownManaweaveBottle(EntityType<? extends EntityThrownManaweaveBottle> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public EntityThrownManaweaveBottle(World worldIn, LivingEntity livingEntityIn) {
        super((EntityType)EntityInit.MANAWEAVE_BOTTLE_THROWN.get(), livingEntityIn, worldIn);
    }

    public EntityThrownManaweaveBottle(World worldIn, double x, double y, double z) {
        super((EntityType)EntityInit.MANAWEAVE_BOTTLE_THROWN.get(), x, y, z, worldIn);
    }

    protected Item func_213885_i() {
        return (Item)ItemInit.MANAWEAVE_BOTTLE.get();
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184543_l();
            ManaweavingPattern p = ItemManaweaveBottle.getPattern(itemstack);
            Entity shooter = this.func_234616_v_();
            if (p != null && shooter != null && shooter instanceof PlayerEntity) {
                PlayerEntity caster = (PlayerEntity)shooter;
                caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> {
                    int tier = progression.getTier();
                    if (tier >= p.getTier()) {
                        EntityManaweave emw = new EntityManaweave(this.field_70170_p);
                        emw.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                        emw.setPattern(p.func_199560_c());
                        emw.setCaster(caster);
                        this.field_70170_p.func_217376_c((Entity)emw);
                    }
                });
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            this.func_70106_y();
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 50; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_GRAVITY.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), -0.5 + Math.random(), -0.5 + Math.random(), -0.5 + Math.random());
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

