/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.models;

import com.ma.entities.models.ModelPositionData;
import com.ma.entities.rituals.EntityAncientCouncil;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class AncientWizardModel
extends EntityModel<EntityAncientCouncil> {
    private final ModelRenderer main;
    private final ModelRenderer right_arm;
    private final ModelRenderer right_elbow;
    private final ModelRenderer left_arm;
    private final ModelRenderer left_elbow;
    private final ModelRenderer cloak;
    private final ModelRenderer head;
    private final ModelRenderer gem;
    private static ModelPositionData neutral;
    private static ModelPositionData imbue_stage_1;
    private static ModelPositionData imbue_stage_2;
    private static ModelPositionData imbue_stage_3;
    private static HashMap<String, ModelPositionData> animationMap;

    public AncientWizardModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.main = new ModelRenderer((Model)this);
        this.main.func_78793_a(0.0f, 24.0f, 0.0f);
        this.main.func_78784_a(48, 22).func_228303_a_(-4.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.main.func_78784_a(48, 22).func_228303_a_(0.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.main.func_78784_a(0, 33).func_228303_a_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f, false);
        this.right_arm = new ModelRenderer((Model)this);
        this.right_arm.func_78793_a(-4.0f, -24.0f, 0.0f);
        this.main.func_78792_a(this.right_arm);
        this.setRotationAngle(this.right_arm, -0.6981f, 0.0f, 0.0f);
        this.right_arm.func_78784_a(48, 0).func_228303_a_(-4.0f, -0.025f, -2.0f, 4.0f, 7.0f, 4.0f, 0.0f, false);
        this.right_elbow = new ModelRenderer((Model)this);
        this.right_elbow.func_78793_a(-1.95f, 6.0f, 0.0f);
        this.right_arm.func_78792_a(this.right_elbow);
        this.setRotationAngle(this.right_elbow, 0.0f, 0.0f, -1.0472f);
        this.right_elbow.func_78784_a(48, 11).func_228303_a_(-2.0f, -1.025f, -1.95f, 4.0f, 7.0f, 4.0f, 0.0f, false);
        this.left_arm = new ModelRenderer((Model)this);
        this.left_arm.func_78793_a(4.0f, -24.0f, 0.0f);
        this.main.func_78792_a(this.left_arm);
        this.setRotationAngle(this.left_arm, -0.6981f, 0.0f, 0.0f);
        this.left_arm.func_78784_a(48, 0).func_228303_a_(0.0f, -0.025f, -2.0f, 4.0f, 7.0f, 4.0f, 0.0f, false);
        this.left_elbow = new ModelRenderer((Model)this);
        this.left_elbow.func_78793_a(2.05f, 6.0f, 0.0f);
        this.left_arm.func_78792_a(this.left_elbow);
        this.setRotationAngle(this.left_elbow, 0.0f, 0.0f, 1.0472f);
        this.left_elbow.func_78784_a(48, 11).func_228303_a_(-2.075f, -1.025f, -1.95f, 4.0f, 7.0f, 4.0f, 0.0f, false);
        this.cloak = new ModelRenderer((Model)this);
        this.cloak.func_78793_a(0.0f, -12.0f, 0.0f);
        this.main.func_78792_a(this.cloak);
        this.cloak.func_78784_a(0, 0).func_228303_a_(-5.0f, -12.0f, -2.0f, 1.0f, 24.0f, 5.0f, 0.0f, false);
        this.cloak.func_78784_a(0, 0).func_228303_a_(4.0f, -12.0f, -2.0f, 1.0f, 24.0f, 5.0f, 0.0f, false);
        this.cloak.func_78784_a(30, 0).func_228303_a_(-4.0f, -12.0f, 2.0f, 8.0f, 24.0f, 1.0f, 0.0f, false);
        this.cloak.func_78784_a(30, 0).func_228303_a_(-5.05f, -12.0f, -2.45f, 4.0f, 12.0f, 1.0f, 0.0f, false);
        this.cloak.func_78784_a(22, 0).func_228303_a_(-5.05f, 0.0f, -2.45f, 3.0f, 4.0f, 1.0f, 0.0f, false);
        this.cloak.func_78784_a(31, 13).func_228303_a_(-5.05f, 4.0f, -2.45f, 2.0f, 7.0f, 1.0f, 0.0f, false);
        this.cloak.func_78784_a(22, 0).func_228303_a_(1.95f, 0.0f, -2.45f, 3.0f, 4.0f, 1.0f, 0.0f, true);
        this.cloak.func_78784_a(31, 13).func_228303_a_(2.95f, 4.0f, -2.45f, 2.0f, 7.0f, 1.0f, 0.0f, true);
        this.cloak.func_78784_a(30, 0).func_228303_a_(0.95f, -12.0f, -2.45f, 4.0f, 12.0f, 1.0f, 0.0f, true);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -24.0f, 0.0f);
        this.main.func_78792_a(this.head);
        this.head.func_78784_a(40, 52).func_228303_a_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
        this.head.func_78784_a(0, 49).func_228303_a_(-4.0f, -6.95f, -4.0f, 8.0f, 7.0f, 8.0f, 0.0f, false);
        this.gem = new ModelRenderer((Model)this);
        this.gem.func_78793_a(0.0f, -21.95f, -1.675f);
        this.main.func_78792_a(this.gem);
        this.setRotationAngle(this.gem, 0.0f, 0.0f, 0.7854f);
        this.gem.func_78784_a(15, 8).func_228303_a_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.gem.func_78784_a(15, 12).func_228303_a_(-0.5f, -0.5f, -0.55f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.initPoses();
    }

    private void initPoses() {
        animationMap = new HashMap();
        neutral = new ModelPositionData();
        neutral.addPositionDegrees(this.head);
        neutral.addPositionDegrees(this.right_arm);
        neutral.addPositionDegrees(this.right_elbow);
        neutral.addPositionDegrees(this.left_arm);
        neutral.addPositionDegrees(this.left_elbow);
        animationMap.put("neutral", neutral);
        imbue_stage_1 = new ModelPositionData();
        imbue_stage_1.addPositionDegrees(this.head, new Vector3(-30.0, 0.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.right_arm, new Vector3(40.0, -45.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 17.5));
        imbue_stage_1.addPositionDegrees(this.left_arm, new Vector3(40.0, 45.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -17.5));
        animationMap.put("imbue_stage_1", imbue_stage_1);
        imbue_stage_2 = new ModelPositionData();
        imbue_stage_2.addPositionDegrees(this.head, new Vector3(30.0, 0.0, 0.0));
        imbue_stage_2.addPositionDegrees(this.right_arm, new Vector3(135.0, 5.0, 44.0));
        imbue_stage_2.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 35.0));
        imbue_stage_2.addPositionDegrees(this.left_arm, new Vector3(125.0, -5.0, -44.0));
        imbue_stage_2.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -35.0));
        animationMap.put("imbue_stage_2", imbue_stage_2);
        imbue_stage_3 = new ModelPositionData();
        imbue_stage_3.addPositionDegrees(this.head, new Vector3(30.0, 0.0, 0.0));
        imbue_stage_3.addPositionDegrees(this.right_arm, new Vector3(95.0, 47.0, 80.0));
        imbue_stage_3.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 15.0));
        imbue_stage_3.addPositionDegrees(this.left_arm, new Vector3(95.0, -47.0, -80.0));
        imbue_stage_3.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -15.0));
        animationMap.put("imbue_stage_3", imbue_stage_3);
    }

    public void setRotationAngles(EntityAncientCouncil entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int lastChange = entity.getLastAnimChangeTimer();
        if (lastChange == 0) {
            animationMap.forEach((s, d) -> d.startLerp());
        } else {
            if (lastChange <= 20) {
                float neutral_return_timer = (float)lastChange / 20.0f;
                neutral.lerpRotations(neutral_return_timer);
            }
            float anim_pct = entity.getAnimationPct(0.0f);
            String current_anim = entity.getCurrentAnimation();
            if (animationMap.containsKey(current_anim)) {
                animationMap.get(current_anim).lerpRotations(anim_pct);
            }
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

