/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class NonClippingBookModel
extends Model {
    private final ModelRenderer coverRight = new ModelRenderer(64, 32, 0, 0).func_228300_a_(-6.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f);
    private final ModelRenderer coverLeft = new ModelRenderer(64, 32, 16, 0).func_228300_a_(0.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f);
    private final ModelRenderer pagesRight;
    private final ModelRenderer pagesLeft;
    private final ModelRenderer flippingPageRight;
    private final ModelRenderer flippingPageLeft;
    private final ModelRenderer bookSpine = new ModelRenderer(64, 32, 12, 0).func_228300_a_(-1.0f, -5.0f, -0.005f, 2.0f, 10.0f, 0.005f);
    private final List<ModelRenderer> bookParts;

    public NonClippingBookModel() {
        super(RenderType::func_228634_a_);
        this.pagesRight = new ModelRenderer(64, 32, 0, 10).func_228300_a_(0.0f, -4.0f, -0.99f, 5.0f, 8.0f, 1.0f);
        this.pagesLeft = new ModelRenderer(64, 32, 12, 10).func_228300_a_(0.0f, -4.0f, -0.01f, 5.0f, 8.0f, 1.0f);
        this.flippingPageRight = new ModelRenderer(64, 32, 24, 10).func_228300_a_(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f);
        this.flippingPageLeft = new ModelRenderer(64, 32, 24, 10).func_228300_a_(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f);
        this.bookParts = ImmutableList.of((Object)this.coverRight, (Object)this.coverLeft, (Object)this.bookSpine, (Object)this.pagesRight, (Object)this.pagesLeft, (Object)this.flippingPageRight, (Object)this.flippingPageLeft);
        this.coverRight.func_78793_a(0.0f, 0.0f, -1.0f);
        this.coverLeft.func_78793_a(0.0f, 0.0f, 1.0f);
        this.bookSpine.field_78796_g = 1.5707964f;
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderAll(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void renderAll(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bookParts.forEach(p_228248_8_ -> p_228248_8_.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha));
    }

    public void setBookState(float p_228247_1_, float rightPageFlipAmount, float leftPageFlipAmount, float bookOpenAmount) {
        float f = (MathHelper.func_76126_a((float)(p_228247_1_ * 0.02f)) * 0.1f + 1.25f) * bookOpenAmount;
        this.coverRight.field_78796_g = (float)Math.PI + f;
        this.coverLeft.field_78796_g = -f;
        this.pagesRight.field_78796_g = f;
        this.pagesLeft.field_78796_g = -f;
        this.flippingPageRight.field_78796_g = f - f * 2.0f * rightPageFlipAmount;
        this.flippingPageLeft.field_78796_g = f - f * 2.0f * leftPageFlipAmount;
        this.pagesRight.field_78800_c = MathHelper.func_76126_a((float)f);
        this.pagesLeft.field_78800_c = MathHelper.func_76126_a((float)f);
        this.flippingPageRight.field_78800_c = MathHelper.func_76126_a((float)f);
        this.flippingPageLeft.field_78800_c = MathHelper.func_76126_a((float)f);
    }
}

