/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.models.constructs;

import com.ma.entities.models.constructs.AnimatedConstructModelBase;
import com.ma.items.constructs.parts._base.ConstructSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class AnimatedConstructModel
extends AnimatedConstructModelBase {
    private HashMap<ConstructSlot, List<ModelToMutex>> partsBySlot = new HashMap();
    private HashMap<ConstructSlot, List<ModelToUUID>> partsByPlayer;

    public AnimatedConstructModel() {
        this.setupMutexes();
        this.initPartsByPlayer();
        this.partsByPlayer.get((Object)ConstructSlot.RIGHT_ARM).add(new ModelToUUID("wrist_pin", UUID.fromString("a4653b22-56ed-45be-bbc5-aae34958ce34")));
    }

    private void initPartsByPlayer() {
        this.partsByPlayer = new HashMap();
        for (ConstructSlot slot : ConstructSlot.values()) {
            this.partsByPlayer.put(slot, new ArrayList());
        }
    }

    private void setupMutexes() {
        this.setMutexAndSlot("head_basic", ConstructSlot.HEAD, 1);
        this.setMutexAndSlot("rebreather", ConstructSlot.HEAD, 2);
        this.setMutexAndSlot("head_smart", ConstructSlot.HEAD, 4);
        this.setMutexAndSlot("torso_basic", ConstructSlot.TORSO, 1);
        this.setMutexAndSlot("torso_armored", ConstructSlot.TORSO, 2);
        this.setMutexAndSlot("torso_mana", ConstructSlot.TORSO, 4);
        this.setMutexAndSlot("right_leg", ConstructSlot.LEGS, 1);
        this.setMutexAndSlot("left_leg", ConstructSlot.LEGS, 1);
        this.setMutexAndSlot("type_bladed_left", ConstructSlot.LEFT_ARM, 4);
        this.setMutexAndSlot("type_grabber_left", ConstructSlot.LEFT_ARM, 1);
        this.setMutexAndSlot("type_hammer_left", ConstructSlot.LEFT_ARM, 2);
        this.setMutexAndSlot("type_axe_left", ConstructSlot.LEFT_ARM, 8);
        this.setMutexAndSlot("type_mana_cannon_left", ConstructSlot.LEFT_ARM, 16);
        this.setMutexAndSlot("type_bladed_right", ConstructSlot.RIGHT_ARM, 4);
        this.setMutexAndSlot("type_grabber_right", ConstructSlot.RIGHT_ARM, 1);
        this.setMutexAndSlot("wrist_pin", ConstructSlot.RIGHT_ARM, 1);
        this.setMutexAndSlot("type_hammer_right", ConstructSlot.RIGHT_ARM, 2);
        this.setMutexAndSlot("type_axe_right", ConstructSlot.RIGHT_ARM, 8);
        this.setMutexAndSlot("type_mana_cannon_right", ConstructSlot.RIGHT_ARM, 16);
    }

    private void setMutexAndSlot(String modelId, ConstructSlot slot, int mutex) {
        if (!this.partsBySlot.containsKey((Object)slot)) {
            this.partsBySlot.put(slot, new ArrayList());
        }
        this.partsBySlot.get((Object)slot).add(new ModelToMutex(modelId, mutex));
    }

    public void setVisibleParts(UUID owner, int headMutex, int torsoMutex, int legsMutex, int leftArmMutex, int rightArmMutex) {
        this.setMutexVisibility(ConstructSlot.HEAD, headMutex, owner);
        this.setMutexVisibility(ConstructSlot.TORSO, torsoMutex, owner);
        this.setMutexVisibility(ConstructSlot.LEGS, legsMutex, owner);
        this.setMutexVisibility(ConstructSlot.LEFT_ARM, leftArmMutex, owner);
        this.setMutexVisibility(ConstructSlot.RIGHT_ARM, rightArmMutex, owner);
    }

    public void resetMutexVisibility() {
        this.setVisibleParts(null, 0, 0, 0, 0, 0);
    }

    public void setMutexVisibility(ConstructSlot slot, int mutex, UUID owner) {
        if (!this.partsBySlot.containsKey((Object)slot)) {
            return;
        }
        for (ModelToMutex m2m : this.partsBySlot.get((Object)slot)) {
            boolean hidden = (m2m.mutex & mutex) == 0;
            this.getBone(m2m.boneId).setHidden(hidden);
        }
        if (owner != null) {
            for (ModelToUUID m2u : this.partsByPlayer.get((Object)slot)) {
                this.getBone(m2u.boneID).setHidden(owner.compareTo(m2u.uuid) == 0);
            }
        } else {
            for (ModelToUUID m2u : this.partsByPlayer.get((Object)slot)) {
                this.getBone(m2u.boneID).setHidden(true);
            }
        }
    }

    class ModelToUUID {
        final String boneID;
        final UUID uuid;

        public ModelToUUID(String boneID, UUID uuid) {
            this.boneID = boneID;
            this.uuid = uuid;
        }
    }

    class ModelToMutex {
        final String boneId;
        final int mutex;

        public ModelToMutex(String boneId, int mutex) {
            this.boneId = boneId;
            this.mutex = mutex;
        }
    }
}

