/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.projectile;

import com.ma.api.particles.ParticleInit;
import com.ma.entities.EntityInit;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySentryProjectile
extends DamagingProjectileEntity {
    private int ticksInAir;
    private static final float DAMAGE = 10.0f;

    public EntitySentryProjectile(EntityType<? extends EntitySentryProjectile> type, World world) {
        super((EntityType)EntityInit.SENTRY_PROJECTILE.get(), world);
        this.func_189654_d(true);
    }

    public EntitySentryProjectile(LivingEntity shooter, World worldIn) {
        this(worldIn, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
        this.func_212361_a((Entity)shooter);
    }

    public EntitySentryProjectile(World worldIn, double x, double y, double z) {
        super((EntityType)EntityInit.SENTRY_PROJECTILE.get(), worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d Vector3d2 = new Vector3d(x, y, z).func_72432_b().func_186678_a((double)velocity);
        this.func_213317_d(Vector3d2);
        float f = MathHelper.func_76133_a((double)EntitySentryProjectile.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void spawnParticles(int particleCount, float partialTick) {
        this.spawnArcaneParticles(particleCount, partialTick);
    }

    protected void entityHit(LivingEntity living) {
        if (!this.field_70170_p.field_72995_K) {
            living.func_70097_a(DamageSource.field_76376_m, 10.0f);
            this.func_70106_y();
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public Entity getShooter() {
        return null;
    }

    public void func_212361_a(@Nullable Entity entityIn) {
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && (p_213871_1_ != this.getShooter() || this.ticksInAir >= 5));
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity = p_213868_1_.func_216348_a();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            this.entityHit(livingentity);
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        Vector3d Vector3d3;
        Vector3d Vector3d2 = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntitySentryProjectile.func_213296_b((Vector3d)Vector3d2));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        ++this.ticksInAir;
        Vector3d Vector3d22 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d22, Vector3d3 = Vector3d22.func_178787_e(Vector3d2), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            Vector3d3 = raytraceresult.func_216347_e();
        }
        while (this.func_70089_S()) {
            EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(Vector3d22, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = this.getShooter();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.onHit((RayTraceResult)raytraceresult);
                this.field_70160_al = true;
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
        Vector3d2 = this.func_213322_ci();
        double d3 = Vector3d2.field_72450_a;
        double d4 = Vector3d2.field_72448_b;
        double d0 = Vector3d2.field_72449_c;
        double d5 = this.func_226277_ct_() + d3;
        double d1 = this.func_226278_cu_() + d4;
        double d2 = this.func_226281_cx_() + d0;
        float f1 = MathHelper.func_76133_a((double)EntitySentryProjectile.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float f2 = 0.99f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterDrag();
        }
        this.func_213317_d(Vector3d2.func_186678_a((double)f2));
        this.func_70107_b(d5, d1, d2);
        this.func_145775_I();
        if (this.field_70173_aa > 200) {
            this.remove(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySentryProjectile.func_184183_bd()) * d0;
    }

    public void spawnArcaneParticles(int particleCount, float partialTick) {
        Vector3d basePos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d(0.0, 0.0, 0.0);
            Vector3d pos = basePos.func_178787_e(this.func_213322_ci().func_186678_a(Math.random()));
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ARCANE.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }
}

