/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.projectile;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.tools.math.MathUtilities;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityWitchhunterTrickshot
extends Entity {
    protected static final DataParameter<String> EFFECT_ID = EntityDataManager.func_187226_a(EntityWitchhunterTrickshot.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<CompoundNBT> LERPDATA = EntityDataManager.func_187226_a(EntityWitchhunterTrickshot.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final int maxAge = 60;
    private static final float arrowSpawnAge = 10.0f;
    private static final float radius = 4.0f;
    private int effectDuration;
    private int effectMagnitude;
    private Vector3d cachedOffset;
    private Effect cachedEffect;
    private Vector3d potion_control_1;
    private Vector3d potion_control_2;

    public EntityWitchhunterTrickshot(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityWitchhunterTrickshot(World world, Vector3d initialPosition, Vector3d destPos, Effect effect) {
        this(world, initialPosition, destPos, effect, 200, 0);
    }

    public EntityWitchhunterTrickshot(World world, Vector3d initialPosition, Vector3d destPos, Effect effect, int duration, int magnitude) {
        super((EntityType)EntityInit.WITCH_HUNTER_TRICKSHOT.get(), world);
        this.func_70634_a(initialPosition.field_72450_a, initialPosition.field_72448_b, initialPosition.field_72449_c);
        this.setDestinationPoint(destPos);
        this.setEffect(effect);
        this.effectDuration = duration;
        this.effectMagnitude = magnitude;
    }

    public void func_70071_h_() {
        ++this.field_70173_aa;
        if (this.field_70170_p.field_72995_K && (float)this.field_70173_aa == 50.0f) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.HOSTILE, 1.0f, (float)(0.9 + Math.random() * 0.2), false);
        }
        if (this.field_70173_aa == 60 && !this.field_70170_p.field_72995_K) {
            this.applyEffect();
            this.remove(false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K && this.getEffect() != null) {
            this.field_70170_p.func_217379_c(2002, new BlockPos(this.getDestination()), this.getEffect().func_76401_j());
        }
    }

    public boolean renderArrow() {
        return (float)this.field_70173_aa > 50.0f;
    }

    public Vector3d getPotionPosition(float partialTicks) {
        if (!this.calculateControlPoints()) {
            return this.func_213303_ch();
        }
        float f = ((float)this.field_70173_aa + partialTicks) / 60.0f;
        return MathUtilities.bezierVector3d(this.func_213303_ch(), this.getDestination(), this.potion_control_1, this.potion_control_2, f);
    }

    public Vector3d getArrowPosition(float partialTicks) {
        float f = MathUtilities.clamp01(((float)this.field_70173_aa + partialTicks - 50.0f) / 10.0f);
        return MathUtilities.lerpVector3d(this.func_213303_ch(), this.getDestination(), f);
    }

    @Nullable
    public Effect getEffect() {
        if (this.cachedEffect == null) {
            ResourceLocation effectID = new ResourceLocation((String)this.field_70180_af.func_187225_a(EFFECT_ID));
            this.cachedEffect = (Effect)ForgeRegistries.POTIONS.getValue(effectID);
        }
        return this.cachedEffect;
    }

    private void applyEffect() {
        Effect effect = this.getEffect();
        if (effect == null) {
            return;
        }
        List targets = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(new BlockPos(this.getDestination())).func_186662_g(4.0), e -> {
            if (!e.func_70089_S()) {
                return false;
            }
            if (e instanceof PlayerEntity) {
                PlayerEntity p = (PlayerEntity)e;
                IPlayerProgression prog = (IPlayerProgression)p.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                if (prog == null) {
                    return false;
                }
                return prog.getAlliedFaction() != Faction.NONE && prog.getAlliedFaction() != Faction.ANCIENT_WIZARDS;
            }
            return false;
        }).stream().map(e -> (PlayerEntity)e).collect(Collectors.toList());
        for (PlayerEntity e2 : targets) {
            e2.func_195064_c(new EffectInstance(effect, this.effectDuration, this.effectMagnitude));
        }
    }

    public void setEffect(Effect effect) {
        this.field_70180_af.func_187227_b(EFFECT_ID, (Object)effect.getRegistryName().toString());
    }

    public void setDestinationPoint(Vector3d dest) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("x", dest.field_72450_a);
        nbt.func_74780_a("y", dest.field_72448_b);
        nbt.func_74780_a("z", dest.field_72449_c);
        this.field_70180_af.func_187227_b(LERPDATA, (Object)nbt);
        Vector3d vector3d = dest.func_178788_d(this.func_213303_ch()).func_72432_b();
        float f = MathHelper.func_76133_a((double)EntityWitchhunterTrickshot.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private boolean calculateControlPoints() {
        if (this.potion_control_1 != null && this.potion_control_2 != null) {
            return true;
        }
        Vector3d start = this.func_213303_ch();
        Vector3d end = this.getDestination();
        if (start == null || end == null) {
            return false;
        }
        this.potion_control_1 = start.func_178787_e(end.func_178788_d(start).func_186678_a(0.3)).func_72441_c(0.0, 3.0, 0.0);
        this.potion_control_2 = start.func_178787_e(end.func_178788_d(start).func_186678_a(0.6)).func_72441_c(0.0, 3.0, 0.0);
        return true;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(16.0);
    }

    @Nullable
    public Vector3d getDestination() {
        if (this.cachedOffset == null) {
            CompoundNBT nbt = (CompoundNBT)this.field_70180_af.func_187225_a(LERPDATA);
            if (!(nbt != null && nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z"))) {
                return null;
            }
            this.cachedOffset = new Vector3d(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
        }
        return this.cachedOffset;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EFFECT_ID, (Object)Effects.field_76421_d.getRegistryName().toString());
        this.field_70180_af.func_187214_a(LERPDATA, (Object)new CompoundNBT());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("effect")) {
            this.field_70180_af.func_187227_b(EFFECT_ID, (Object)compound.func_74781_a("effect").func_150285_a_());
        }
        if (compound.func_74764_b("lerpdata")) {
            this.field_70180_af.func_187227_b(LERPDATA, (Object)((CompoundNBT)compound.func_74781_a("lerpdata")));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("effect", (String)this.field_70180_af.func_187225_a(EFFECT_ID));
        compound.func_218657_a("lerpdata", (INBT)this.field_70180_af.func_187225_a(LERPDATA));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

