/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.constructs.animated.AnimatedConstructConstruction;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.models.constructs.AnimatedConstructModel;
import com.ma.items.constructs.parts._base.ConstructMaterial;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class EntityAnimatedConstructRenderer
extends GeoEntityRenderer<EntityAnimatedConstruct> {
    private ResourceLocation constructTexture = new ResourceLocation("mana-and-artifice", "textures/entity/animated_construct/stone.png");
    private IRenderTypeBuffer rtb;
    private ItemStack mainHand = ItemStack.field_190927_a;
    private ItemStack offHand = ItemStack.field_190927_a;

    public EntityAnimatedConstructRenderer(EntityRendererManager renderManager) {
        super(renderManager, (AnimatedGeoModel)new AnimatedConstructModel());
    }

    public RenderType getRenderType(EntityAnimatedConstruct animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228646_f_((ResourceLocation)textureLocation);
    }

    public void renderEarly(EntityAnimatedConstruct animatable, MatrixStack stackIn, float ticks, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        this.constructTexture = this.getTextureLocation((LivingEntity)animatable);
        this.mainHand = animatable.func_184614_ca();
        this.offHand = animatable.func_184592_cb();
        super.renderEarly((Object)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public void render(EntityAnimatedConstruct entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        AnimatedConstructModel model = (AnimatedConstructModel)this.getGeoModelProvider();
        AnimatedConstructConstruction data = entityIn.getConstructData();
        if (this.getGeoModelProvider() instanceof IAnimatableModel) {
            model.getModel(model.getModelLocation(entityIn));
            for (ConstructMaterial matl : data.getComposition()) {
                model.resetMutexVisibility();
                model.setActiveMaterial(matl);
                for (ItemConstructPart part : data.getPartsForMaterial(matl)) {
                    model.setMutexVisibility(part.getSlot(), part.getModelTypeMutex(), entityIn.getOwner() != null ? entityIn.getOwner().func_110124_au() : null);
                }
                matrixStackIn.func_227860_a_();
                super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    public void renderRecursively(GeoBone arg0, MatrixStack arg1, IVertexBuilder arg2, int arg3, int arg4, float arg5, float arg6, float arg7, float arg8) {
        if (arg0.getName().equals("right_arm_held_item") && !this.offHand.func_190926_b()) {
            arg1.func_227860_a_();
            arg1.func_227861_a_(0.38, 0.23, -0.1);
            arg1.func_227862_a_(0.7f, 0.7f, 0.7f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.offHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, arg3, arg4, arg1, this.rtb);
            arg1.func_227865_b_();
            arg2 = this.rtb.getBuffer(RenderType.func_228646_f_((ResourceLocation)this.constructTexture));
        } else if (arg0.getName().equals("left_arm_held_item") && !this.mainHand.func_190926_b()) {
            arg1.func_227860_a_();
            arg1.func_227861_a_(-0.38, 0.23, -0.1);
            arg1.func_227862_a_(0.7f, 0.7f, 0.7f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.mainHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, arg3, arg4, arg1, this.rtb);
            arg1.func_227865_b_();
            arg2 = this.rtb.getBuffer(RenderType.func_228646_f_((ResourceLocation)this.constructTexture));
        }
        super.renderRecursively(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    protected boolean canRenderName(EntityAnimatedConstruct entity) {
        return false;
    }
}

