/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class EntityManaweaveRenderer
extends EntityRenderer<EntityManaweave> {
    private static final ResourceLocation SPARKLE_TEXTURE = new ResourceLocation("mana-and-artifice", "textures/particle/sparkle.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228642_d_((ResourceLocation)SPARKLE_TEXTURE);

    public EntityManaweaveRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityManaweave entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        ArrayList<ManaweavingPattern> patterns = entityIn.getPatterns();
        if (patterns == null) {
            return;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.5, 0.0);
        for (ManaweavingPattern p : patterns) {
            this.RenderPattern(p, matrixStackIn, bufferIn);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void RenderPattern(ManaweavingPattern pattern, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        byte[][] points = pattern.get();
        float offsetX = (float)points.length / 2.0f;
        float offsetY = (float)points[0].length / 2.0f;
        Quaternion cameraRotation = this.field_76990_c.func_229098_b_();
        Quaternion portalRotation = new Quaternion(cameraRotation.func_195889_a(), cameraRotation.func_195891_b(), cameraRotation.func_195893_c(), cameraRotation.func_195894_d());
        float baseScale = 0.125f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(portalRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227861_a_(-2.6 * (double)baseScale, -2.6 * (double)baseScale, 0.0);
        matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * 0.5f;
                float originY = offsetY - (float)i * 0.5f;
                EntityManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f);
                EntityManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f);
                EntityManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f);
                EntityManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(128, 34, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF00000).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public ResourceLocation getEntityTexture(EntityManaweave entity) {
        return SPARKLE_TEXTURE;
    }
}

