/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.rituals.EntityTimeChangeBall;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class EntityTimeChangeBallRenderer
extends EntityRenderer<EntityTimeChangeBall> {
    private static final float triangle_height = (float)(Math.sqrt(3.0) / 2.0);
    private static final int[] sun_orange_start = new int[]{255, 255, 0};
    private static final int[] sun_orange_end = new int[]{255, 120, 0};
    private static final int[] moon_blue_start = new int[]{0, 255, 255};
    private static final int[] moon_blue_end = new int[]{0, 0, 255};
    private static final int[] moon_purp_start = new int[]{255, 0, 255};
    private static final int[] moon_purp_end = new int[]{138, 0, 255};

    public EntityTimeChangeBallRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityTimeChangeBall entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        EntityTimeChangeBallRenderer.renderRadiant(entityIn, matrixStackIn, bufferIn, 0.0f);
    }

    private static void renderRadiant(EntityTimeChangeBall entityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float offsetFactor) {
        float rotationByAge = ((float)entityIn.getAge() + offsetFactor) / 220.0f;
        Random random = new Random(1234L);
        IVertexBuilder lightingBuilder = bufferIn.getBuffer(RenderType.func_228657_l_());
        matrixStackIn.func_227860_a_();
        Vector3d motion = entityIn.func_213322_ci();
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-entityIn.field_70125_A));
        matrixStackIn.func_227862_a_((float)motion.field_72450_a, (float)motion.field_72448_b, (float)motion.field_72449_c);
        for (int i = 0; i < 40; ++i) {
            int[] colorEnd;
            int[] colorStart;
            float f = random.nextFloat();
            if (entityIn.getTimeChangeType() == EntityTimeChangeBall.TIME_CHANGE_DAY.byteValue()) {
                colorStart = sun_orange_start;
                colorEnd = sun_orange_end;
            } else if ((double)f > 0.5) {
                colorStart = moon_blue_start;
                colorEnd = moon_blue_end;
            } else {
                colorStart = moon_purp_start;
                colorEnd = moon_purp_end;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f currentMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
            int alpha = 255;
            EntityTimeChangeBallRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            EntityTimeChangeBallRenderer.addVertexNegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            EntityTimeChangeBallRenderer.addVertexPositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            EntityTimeChangeBallRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            EntityTimeChangeBallRenderer.addVertexPositiveOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            EntityTimeChangeBallRenderer.addVertexNoOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            EntityTimeChangeBallRenderer.addStartVertices(lightingBuilder, currentMatrix, alpha, colorStart);
            EntityTimeChangeBallRenderer.addVertexNoOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
            EntityTimeChangeBallRenderer.addVertexNegativeOffset(lightingBuilder, currentMatrix, hOffset, vOffset, colorEnd);
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addStartVertices(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, int alpha, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_181675_d();
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(colors[0], colors[1], colors[2], alpha).func_181675_d();
    }

    private static void addVertexNegativeOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, -triangle_height * hOffset, vOffset, -0.5f * hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }

    private static void addVertexPositiveOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, triangle_height * hOffset, vOffset, -0.5f * hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }

    private static void addVertexNoOffset(IVertexBuilder vertexBuilder, Matrix4f renderMatrix, float vOffset, float hOffset, int[] colors) {
        vertexBuilder.func_227888_a_(renderMatrix, 0.0f, vOffset, hOffset).func_225586_a_(colors[0], colors[1], colors[2], 0).func_181675_d();
    }

    public ResourceLocation getEntityTexture(EntityTimeChangeBall entity) {
        return null;
    }
}

