/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers.ritual;

import com.ma.entities.utility.EntityDisplayReagents;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class EntityDisplayReagentsRenderer
extends EntityRenderer<EntityDisplayReagents> {
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();

    public EntityDisplayReagentsRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getEntityTexture(EntityDisplayReagents entity) {
        return null;
    }

    public void render(EntityDisplayReagents entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        List<ResourceLocation> reagents = entityIn.getResourceLocations();
        float displayItemWidth = 0.0625f;
        float offset = (float)reagents.size() * displayItemWidth;
        Quaternion cameraRotation = this.field_76990_c.func_229098_b_();
        Quaternion portalRotation = new Quaternion(0.0f, cameraRotation.func_195891_b(), 0.0f, cameraRotation.func_195894_d());
        int multiItemIndex = entityIn.getAge() / 40;
        int count = 0;
        float scaleFactor = 0.25f;
        for (ResourceLocation location : reagents) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)(offset * (float)reagents.size() / 2.0f - displayItemWidth * 2.0f), 1.0, 0.0);
            matrixStackIn.func_227861_a_((double)(-offset * (float)count), 0.0, 0.0);
            matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(portalRotation);
            List<Item> item = MATags.smartLookupItem(location);
            ItemStack renderStack = item.size() == 1 ? new ItemStack((IItemProvider)item.get(0)) : new ItemStack((IItemProvider)item.get(multiItemIndex % item.size()));
            if (renderStack != null) {
                this.itemRenderer.func_229110_a_(renderStack, ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            }
            matrixStackIn.func_227865_b_();
            this.func_225629_a_(entityIn, (ITextComponent)new StringTextComponent("" + (count + 1)), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
            ++count;
        }
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

