/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.ManaAndArtifice;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityDemonLord;
import com.ma.sound.EntityAliveLoopingSound;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDemonStone
extends Entity {
    protected int age = 0;
    private static final DataParameter<String> CASTER_UUID = EntityDataManager.func_187226_a(EntityDemonStone.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityDemonStone(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        ++this.age;
        if (this.field_70170_p.field_72995_K) {
            this.playSounds();
            this.spawnParticles();
        }
        if (this.age > 200 && !this.field_70170_p.field_72995_K) {
            this.remove(false);
            EntityDemonLord edl = (EntityDemonLord)((EntityType)EntityInit.DEMON_LORD.get()).func_220331_a((ServerWorld)this.field_70170_p, null, null, this.func_233580_cy_(), SpawnReason.EVENT, false, false);
            edl.setCasterUUID(this.getCasterUUID());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSounds() {
        if (this.age == 1) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityAliveLoopingSound(SFX.Loops.DEMON_SUMMON, this));
        } else if (this.age == 120) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.DEMON_SUMMON_END, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    private void spawnParticles() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218424_l, this.func_226277_ct_() - 1.5 + Math.random() * 3.0, this.func_226278_cu_(), this.func_226281_cx_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
        if (this.age < 150) {
            for (i = 0; i < 5; ++i) {
                boolean xAxis = Math.random() > 0.5;
                boolean positive = Math.random() > 0.5;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196653_dH.func_176223_P()), xAxis ? (positive ? this.func_226277_ct_() + 2.5 - Math.random() * 0.5 : this.func_226277_ct_() - 2.5 + Math.random() * 0.5) : this.func_226277_ct_() + 2.5 - Math.random() * 5.0, this.func_226278_cu_(), !xAxis ? (positive ? this.func_226281_cx_() + 2.5 - Math.random() * 0.5 : this.func_226281_cx_() - 2.5 + Math.random() * 0.5) : this.func_226281_cx_() + 2.5 - Math.random() * 5.0, 0.0, (double)0.05f, 0.0);
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() - 0.5 + Math.random() * 1.0, this.func_226278_cu_(), this.func_226281_cx_() - 0.5 + Math.random() * 1.0, 0.0, (double)0.05f, 0.0);
        if (this.age > 160) {
            for (i = 0; i < 25; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), this.func_226277_ct_() - 0.25 + Math.random() * 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.25 + Math.random() * 0.5, 0.0, (double)0.15f, 0.0);
            }
        }
        if (this.age == 199) {
            for (i = 0; i < 100; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196653_dH.func_176223_P()), this.func_226277_ct_() - 1.5 + Math.random() * 3.0, this.func_226278_cu_() + 1.5, this.func_226281_cx_() - 1.5 + Math.random() * 3.0, -0.5 + Math.random(), 0.0, -0.5 + Math.random());
            }
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public int getAge() {
        return this.age;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CASTER_UUID, (Object)"");
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("age")) {
            this.age = compound.func_74762_e("age");
        }
        if (compound.func_74764_b("caster")) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)compound.func_74779_i("caster"));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("age", this.age);
        compound.func_74778_a("caster", (String)this.field_70180_af.func_187225_a(CASTER_UUID));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.field_70180_af.func_187225_a(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }
}

