/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.LivingUtilityEntity;
import com.ma.items.ItemInit;
import com.ma.tools.math.MathUtilities;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityFaerieQueen
extends LivingUtilityEntity {
    public static final byte STATE_WAITING_ITEM = 0;
    public static final byte STATE_CONSUMING = 1;
    public static final byte STATE_TRANSFORMING = 2;
    public static final byte STATE_IMBUING = 3;

    public EntityFaerieQueen(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.func_184224_h(true);
        this.stateMachine.addSequenceEntry("consume", 0).onComplete(() -> {
            this.setCurrentAnimation("consuming_item_start");
            if (!this.field_70170_p.field_72995_K) {
                if (this.caster != null) {
                    this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 190, 1));
                }
            } else {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.FAERIE_GIGGLE, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        this.stateMachine.addSequenceEntry("consume", 20).onTick(c -> {
            this.animationPct = (float)c.intValue() / 20.0f;
        });
        this.stateMachine.addSequenceEntry("consume", 5).onComplete(() -> {
            this.setCurrentAnimation("consuming_item_end");
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.FAERIE_IMBUE, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        this.stateMachine.addSequenceEntry("consume", 20).onTick(c -> {
            this.animationPct = (float)c.intValue() / 20.0f;
        });
        this.stateMachine.addSequenceEntry("consume", 60).onComplete(() -> {
            this.setCurrentAnimation("");
            if (!this.field_70170_p.field_72995_K && this.caster != null) {
                this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 180, 2));
            }
            if (this.caster != null && this.caster.func_70032_d((Entity)this) < 10.0f) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 75; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleInit.SPARKLE_VELOCITY.get(), this.caster.func_226277_ct_(), this.caster.func_226278_cu_() + 1.0, this.caster.func_226281_cx_(), -0.25 + Math.random() * 0.5, (double)0.15f, -0.25 + Math.random() * 0.5);
                    }
                } else {
                    IPlayerProgression progression = (IPlayerProgression)this.caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    if (progression != null && progression.getTier() < 5) {
                        if (progression.getAlliedFaction() == Faction.NONE) {
                            progression.setAlliedFaction(Faction.FEY_COURT);
                            this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ally_fey"), Util.field_240973_b_);
                        }
                        if (progression.getAlliedFaction() == Faction.FEY_COURT) {
                            progression.setTier(progression.getTier() + 1, this.caster);
                            this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.advanced", new Object[]{progression.getTier()}), Util.field_240973_b_);
                        }
                    }
                }
            }
        });
        this.stateMachine.addSequenceEntry("imbue", 0).onComplete(() -> this.setCurrentAnimation("kiss_start"));
        this.stateMachine.addSequenceEntry("imbue", 20).onComplete(() -> this.setCurrentAnimation("kiss_end")).onTick(c -> {
            this.animationPct = (float)c.intValue() / 20.0f;
            if (this.field_70170_p.field_72995_K && c == 10) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.FAERIE_BLOW_KISS, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        this.stateMachine.addSequenceEntry("imbue", 5).onTick(c -> {
            this.animationPct = (float)c.intValue() / 5.0f;
        });
        this.stateMachine.addSequenceEntry("imbue", 60).onComplete(() -> {
            this.setCurrentAnimation("");
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.FAERIE_LEAVE, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
            this.disableFlightFor(this.caster);
        }).onTick(c -> {
            PlayerEntity player;
            if (this.field_70170_p.field_72995_K && (player = this.getCaster()) != null) {
                Vector3d diff = player.func_174824_e(0.0f).func_178786_a(0.0, 1.0, 0.0).func_72441_c(-0.6 * Math.random() * 1.2, -0.6 * Math.random() * 1.2, -0.6 * Math.random() * 1.2).func_178788_d(this.func_213303_ch()).func_216372_d((double)0.1f, (double)0.1f, (double)0.1f);
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.HEART.get(), this.func_226277_ct_(), this.func_226278_cu_() + (double)1.55f, this.func_226281_cx_(), diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
            }
        });
    }

    @Override
    public void func_70071_h_() {
        UUID caster;
        boolean remove;
        this.field_70733_aJ = 0.5f;
        super.func_70071_h_();
        boolean bl = remove = this.field_70173_aa > 600;
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            this.playSounds();
        }
        if ((caster = this.getCasterUUID()) != null) {
            PlayerEntity player = this.field_70170_p.func_217371_b(caster);
            if (player != null) {
                this.updateRotations(player);
                if (this.getState() == 0) {
                    this.updateArmRaise(player);
                } else {
                    remove = this.updateStateLogic(player);
                }
            } else {
                remove = true;
            }
        }
        if (remove) {
            this.func_213293_j(0.0, 0.4, 0.0);
            this.field_70145_X = true;
            if (!this.field_70170_p.field_72995_K && this.func_226278_cu_() > 300.0) {
                this.remove(false);
            }
        }
    }

    private void updateArmRaise(PlayerEntity player) {
        float animPct = this.lastTickAnimationPct;
        animPct = player.func_70068_e((Entity)this) > 64.0 ? (animPct -= 0.1f) : (animPct += 0.1f);
        animPct = MathUtilities.clamp01(animPct);
        this.field_70180_af.func_187227_b(CURRENT_ANIMATION, (Object)"waiting_item");
        this.animationPct = animPct;
    }

    private boolean updateStateLogic(PlayerEntity player) {
        if (player.func_70068_e((Entity)this) > 64.0) {
            return true;
        }
        if (this.getState() == 1) {
            if (this.stateTicks == 1) {
                this.stateMachine.runSequence("consume");
            }
            if (!this.stateMachine.isComplete()) {
                this.stateMachine.tick();
            } else {
                this.setState((byte)3);
            }
        } else if (this.getState() == 3) {
            if (this.stateTicks == 1) {
                this.stateMachine.runSequence("imbue");
            }
            if (!this.stateMachine.isComplete()) {
                this.stateMachine.tick();
            } else {
                return true;
            }
        }
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == STATE) {
            this.stateTicks = 0;
        }
        super.func_184206_a(key);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.disableFlightFor(this.caster);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        PlayerEntity mySummoner;
        if (this.getState() != 0) {
            return ActionResultType.FAIL;
        }
        UUID caster = this.getCasterUUID();
        if (caster != null && player != (mySummoner = this.field_70170_p.func_217371_b(caster))) {
            return ActionResultType.FAIL;
        }
        if (player.func_184586_b(hand).func_77973_b() == ItemInit.ENCHANTMENT_FOCUS_AIR.get()) {
            player.func_184607_cu().func_190918_g(1);
            this.setState((byte)1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    private void updateRotations(PlayerEntity player) {
        float targetRotation;
        double d0 = this.func_226277_ct_() - player.func_226277_ct_();
        double d1 = this.func_226281_cx_() - player.func_226281_cx_();
        this.field_70126_B = this.field_70177_z;
        this.field_70177_z = targetRotation = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) + 90.0f;
        this.field_70759_as = targetRotation;
    }

    private void spawnParticles() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleInit.SPARKLE_STATIONARY.get(), this.func_226277_ct_() - 0.5 + Math.random(), this.func_226278_cu_() + Math.random() * 2.0, this.func_226281_cx_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
    }

    private void playSounds() {
    }
}

