/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.ItemInit;
import com.ma.tools.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityPortal
extends Entity {
    private static final String KEY_AGE = "age";
    private static final String KEY_PERMANENT = "permanent";
    private static final String KEY_COLOR = "color";
    private static final String KEY_TP_X = "teleport_pos_x";
    private static final String KEY_TP_Y = "teleport_pos_y";
    private static final String KEY_TP_Z = "teleport_pos_z";
    private static final String KEY_TP_DIM_KEYTYPE = "dimension_key_type";
    private static final String KEY_TP_DIM_KEY = "dimension_key";
    private static final DataParameter<BlockPos> TELEPORT_POS = EntityDataManager.func_187226_a(EntityPortal.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> DYE_COLOR = EntityDataManager.func_187226_a(EntityPortal.class, (IDataSerializer)DataSerializers.field_187192_b);
    private RegistryKey<World> dimension;
    private int age = 0;
    private int maxAge = 200;
    private boolean permanent = false;

    public EntityPortal(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        ++this.age;
        this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), e -> e.func_70089_S() && e instanceof ItemEntity).stream().map(e -> (ItemEntity)e).forEach(e -> {
            ItemStack stack = e.func_92059_d();
            if (stack.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleInit.SPARKLE_GRAVITY.get(), e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 0.0, 0.0, 0.0);
                } else {
                    this.maxAge = this.age + 20;
                    this.permanent = false;
                    e.func_70106_y();
                }
            }
        });
        if (!this.field_70170_p.field_72995_K && !this.permanent && this.getAge() >= this.maxAge) {
            this.remove(false);
        }
    }

    public void func_70030_z() {
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TELEPORT_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)-1);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b(KEY_AGE)) {
            this.age = compound.func_74762_e(KEY_AGE);
        }
        if (compound.func_74764_b(KEY_TP_X) && compound.func_74764_b(KEY_TP_Y) && compound.func_74764_b(KEY_TP_Z) && compound.func_74764_b(KEY_TP_DIM_KEY) && compound.func_74764_b(KEY_TP_DIM_KEYTYPE)) {
            this.setTeleportBlockPos(new BlockPos(compound.func_74762_e(KEY_TP_X), compound.func_74762_e(KEY_TP_Y), compound.func_74762_e(KEY_TP_Z)), (RegistryKey<World>)new RegistryKey(new ResourceLocation(compound.func_74779_i(KEY_TP_DIM_KEY)), new ResourceLocation(compound.func_74779_i(KEY_TP_DIM_KEYTYPE))));
        }
        if (compound.func_74764_b(KEY_PERMANENT)) {
            this.permanent = compound.func_74767_n(KEY_PERMANENT);
        }
        if (compound.func_74764_b(KEY_COLOR)) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)compound.func_74762_e(KEY_COLOR));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(KEY_AGE, this.getAge());
        compound.func_74757_a(KEY_PERMANENT, this.permanent);
        compound.func_74768_a(KEY_COLOR, ((Integer)this.field_70180_af.func_187225_a(DYE_COLOR)).intValue());
        compound.func_74768_a(KEY_TP_X, this.getTeleportBlockPos().func_177958_n());
        compound.func_74768_a(KEY_TP_Y, this.getTeleportBlockPos().func_177956_o());
        compound.func_74768_a(KEY_TP_Z, this.getTeleportBlockPos().func_177952_p());
        compound.func_74778_a(KEY_TP_DIM_KEY, this.dimension.getRegistryName().toString());
        compound.func_74778_a(KEY_TP_DIM_KEYTYPE, this.dimension.func_240901_a_().toString());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void setTeleportBlockPos(BlockPos pos, RegistryKey<World> dimension) {
        this.field_70180_af.func_187227_b(TELEPORT_POS, (Object)pos);
        this.dimension = dimension;
    }

    public BlockPos getTeleportBlockPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TELEPORT_POS);
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.getAge() < 40) {
            return;
        }
        if (entityIn.func_225608_bj_()) {
            return;
        }
        LazyOptional magicContainer = entityIn.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicContainer.isPresent()) {
            return;
        }
        if (((IPlayerMagic)magicContainer.orElse(null)).getPortalCooldown() > 0) {
            return;
        }
        BlockPos tpPos = this.getTeleportBlockPos();
        if (tpPos == BlockPos.field_177992_a) {
            return;
        }
        if (!entityIn.field_70170_p.field_72995_K) {
            entityIn.func_184102_h().func_212370_w().iterator().forEachRemaining(sw -> {
                if (this.dimension.toString().equals(sw.func_234923_W_().toString())) {
                    this.dimension = sw.func_234923_W_();
                }
            });
            TeleportHelper.teleportEntity((Entity)entityIn, this.dimension, new Vector3d((double)((float)tpPos.func_177958_n() + 0.5f), (double)((float)tpPos.func_177956_o() + 0.5f), (double)((float)tpPos.func_177952_p() + 0.5f)));
        } else {
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.SPARKLE_RANDOM.get(), entityIn.func_226277_ct_() - 1.0 + Math.random() * 2.0, entityIn.func_226278_cu_() + Math.random() * 2.0, entityIn.func_226281_cx_() - 1.0 + Math.random() * 2.0, (double)0.1f, (double)0.1f, (double)0.1f);
            }
        }
        ((IPlayerMagic)magicContainer.orElse(null)).setPortalCooldown(60);
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Nullable
    public DyeColor getDyeColor() {
        int color = (Integer)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (color == -1) {
            return null;
        }
        return DyeColor.func_196056_a((int)color);
    }

    public void setDyeColor(DyeColor color) {
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)color.func_196059_a());
    }

    public void setPermanent() {
        this.permanent = true;
    }
}

